/**************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto , (c)2004 by 421                 *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITADATMG_H
#define KITADATMG_H

#include <qvaluelist.h>

class QMutex;
class QStringList;
class KURL;
class QObject;

namespace DOM
{
class HTMLDocument;
class Element;
} 

namespace Kita
{

class DatInfo;
typedef QValueList<DatInfo*> DatInfoList;

class DatManager
    {
	static DatInfoList m_datInfo;
	static QMutex m_mutex;

      public:

	static DatInfo* getDatInfoPointer( const KURL& url );
	static void deleteDatInfo( const KURL& url );

	/* caching */
	static bool updateCache( const KURL& url , const QObject* parent);
	static int getResponseCode( const KURL& url );
	static int getServerTime( const KURL& url );
	static bool deleteCache( const KURL& url , QWidget* parent);
	static bool isLoadingNow( const KURL& url );
	static void stopLoading( const KURL& url );


	/* lock, unlock */
	static void lock( const KURL& url );
	static void unlock( const KURL& url );	

	/* string data */
	static const QString& getRawDat( const KURL& url );	
	static const QString& getDat( const KURL& url, int num );
	static const QString& getId( const KURL& url, int num );
	static const QString& getName( const KURL& url, int num );
	static const QString& getBody( const KURL& url, int num );	
	static QString getPlainName( const KURL& url, int num );
	static QString getPlainBody( const KURL& url, int num );
	static QString getPlainTitle( const KURL& url, int num );

	static const QString  threadURL( const KURL& url );
	static const QString& threadName( const KURL& url );/* = subject of thread */
	static const QString  threadID( const KURL& url );

	static const QString  boardURL( const KURL& url );
	static const QString& boardName( const KURL& url );
	static const QString  boardID( const KURL& url );

	
	/* HTML data */
	static QString getHtml( const KURL& url, int startnum, int endnum);
	static QString getHtmlByID(const KURL& url, const QString& strid, int &count );
	static QString getTreeByRes(const KURL& url, const int rootnum, int &count);
	static QString getTreeByResReverse(const KURL& url, const int rootnum, int &count);

	/* DOM element */
	static bool getDomElement(const KURL& url, int num, DOM::HTMLDocument& hdoc, DOM::Element& retelm);
	
	/* numerical data */
	static int getResNum( const KURL& url );
	static int getReadNum( const KURL& url );	
	static int getKokoyonNum( const KURL& url );
	static void setKokoyonNum( const KURL& url, int num);
	static int getDatSize(  const KURL& url );
	static int getNumByID( const KURL& url, const QString& strid );
	
	/* another information */
	static bool isResValid( const KURL& url , int num);
	static bool isBroken( const KURL& url );	
	static bool isResBroken( const KURL& url , int num);
	static bool checkID(const KURL& url, const QString& strid, int num );
	static bool checkWord(const KURL& url,QStringList& stlist, int num, bool checkOR);
	static bool isMarked( const KURL& url, int num );
	static void setMark( const KURL& url, int num, bool mark );	


	/* abone check */
	static bool checkAbone(const KURL& url, int num);
	static void resetAbone(const KURL& url );

	/* obsolete. Don't use them. */
	static const QString  thread_url( const KURL& url ){return threadURL(url);}
	static const QString& thread_name( const KURL& url ){return threadName(url);}
	static const QString  thread_datID( const KURL& url ){return threadID(url);}
	static const QString  thread_boardURL( const KURL& url ){return boardURL(url);}
	static const QString& thread_boardName( const KURL& url ){return boardName(url);}
	static const QString  thread_boardID( const KURL& url ){return boardID(url);}
	
      private:

	static DatInfo* getDatInfo( const KURL& url );
	static void deleteDatInfoPrivate( const KURL& url );	
    };

}

#endif
