/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef K2CH_ARTICLEFILE_H
#define K2CH_ARTICLEFILE_H

#include <qstring.h>
#include <qvaluelist.h>
#include <time.h>

/**
@author Hideki Ikemoto
*/

class K2chArticleFileItem {
  QString m_name;      // "1053683473" Τ褦.dat̾
  int m_seen;
  time_t m_accessTime;
public:
  K2chArticleFileItem( QString&, int seen, time_t accessTime );
  K2chArticleFileItem() : m_name( "" ), m_seen( 0 ), m_accessTime( 0 ) {}
  ~K2chArticleFileItem();
  QString toString();
  QString& name() { return m_name; }
  int seen() { return m_seen; }
  time_t accessTime() { return m_accessTime; }
};

// navi2charticle-summaryե륯饹

class K2chArticleFile {
  QString m_filePath;
  QValueList<K2chArticleFileItem> m_list;
public:
  K2chArticleFile( QString& filepath );
  K2chArticleFile() {}
  ~K2chArticleFile();
  void parse( QString str );
  QString toString();

  int count();
  K2chArticleFileItem& item( int i );
};

#endif
