/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAKITA_MISC_H
#define KITAKITA_MISC_H

#include <qstring.h>

namespace Kita
{
    enum {
        Board_MachiBBS,
        Board_JBBS,
        Board_2ch
    };

    /**
     * @author Hideki Ikemoto
     */

    QString datToBoard( const QString& datURL );
    QString datToThread( const QString& datURL );
    QString threadToDat( const QString& threadURL );
    QString boardToSubject( const QString& boardURL );
    QString subjectToBoard( const QString& subjectURL );
    QString datToCache( const QString& datURL );
    QString httpToK2ch( const QString& httpURL );
    QString unescape( const QString& str );
    int boardType( const QString& url );
    uint datToSince( const QString& datURL );
}

#endif
