/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITACONFIG_H
#define KITACONFIG_H

#include <qfont.h>

#include <kcompletion.h>

/**
@author Hideki Ikemoto
*/
class KitaConfig
{
public:
    enum SortOrder {
        Order_Mark,
        Order_ID
    };

    enum ViewMode {
        View_2pane,
        View_3pane
    };
    
private:
    static KitaConfig* instance;
    QColor m_threadColor;
    QColor m_threadBackgroundColor;
    QColor m_popupColor;
    QColor m_popupBackgroundColor;
    QFont m_font;
    QFont m_threadFont;
    QString m_boardListURL;
    KCompletion m_nameCompletion;
    QStringList m_asciiArtList;
    bool m_showMailAddress;
    QStringList m_aboneNameList;
    QStringList m_aboneIDList;
    QStringList m_aboneWordList;
    int m_MarkTime;
    bool m_alwaysUseTab;
    ViewMode m_viewMode;
    SortOrder m_sortOrder;
    bool m_showAA;
    int m_afterShowNum;
    int m_preShowNum;
    bool m_usePart;
    QStringList m_partMimeList;
    
    KitaConfig();
    virtual ~KitaConfig();
public:
    static KitaConfig* getInstance();
    static QFont& font() { return getInstance() ->m_font; }
    static void setFont( QFont font ) { getInstance() ->m_font = font; }
    static QFont& threadFont() { return getInstance() ->m_threadFont; }
    static void setThreadFont( QFont font ) { getInstance() ->m_threadFont = font; }
    static void setBoardListURL( QString url ) { getInstance() ->m_boardListURL = url; }
    static QString& boardListURL() { return getInstance() ->m_boardListURL; }
    static KCompletion* nameCompletion() { return & ( getInstance() ->m_nameCompletion ); }
    static void addNameCompletionItem( QString& item ) { getInstance() ->m_nameCompletion.addItem( item ); }
    static void setNameCompletionItems( QStringList list ) { getInstance() ->m_nameCompletion.setItems( list ); }
    static QColor& threadColor() { return getInstance() ->m_threadColor; }
    static void setThreadColor( QColor color ) { getInstance() ->m_threadColor = color; }
    static QColor& threadBackgroundColor() { return getInstance() ->m_threadBackgroundColor; }
    static void setThreadBackgroundColor( QColor color ) { getInstance() ->m_threadBackgroundColor = color; }
    static QColor& popupColor() { return getInstance() ->m_popupColor; }
    static void setPopupColor( QColor color ) { getInstance() ->m_popupColor = color; }
    static QColor& popupBackgroundColor() { return getInstance() ->m_popupBackgroundColor; }
    static void setPopupBackgroundColor( QColor color ) { getInstance() ->m_popupBackgroundColor = color; }
    static QStringList& asciiArtList() { return getInstance() ->m_asciiArtList; }
    static void setAsciiArtList( QStringList list ) { getInstance() ->m_asciiArtList = list; }
    static bool showMailAddress() { return getInstance() ->m_showMailAddress; }
    static void setShowMailAddresss( bool flag ) { getInstance() ->m_showMailAddress = flag; }
    static QStringList& aboneNameList() { return getInstance() ->m_aboneNameList; }
    static void setAboneNameList( QStringList list ) { getInstance() ->m_aboneNameList = list; }
    static void addAboneName( QString name ) { getInstance() ->m_aboneNameList.append( name ); }    
    static QStringList& aboneIDList() { return getInstance() ->m_aboneIDList; }
    static void setAboneIDList( QStringList list ) { getInstance() ->m_aboneIDList = list; }
    static void addAboneID( QString id ) { getInstance() ->m_aboneIDList.append( id ); }
    static QStringList& aboneWordList() { return getInstance() ->m_aboneWordList; }
    static void setAboneWordList( QStringList list ) { getInstance() ->m_aboneWordList = list; }
    static void addAboneWord( QString word ) { getInstance() ->m_aboneWordList.append( word ); }
    static bool alwaysUseTab() { return getInstance() ->m_alwaysUseTab; }
    static void setAlwaysUseTab( bool on ) { getInstance() ->m_alwaysUseTab = on; }
    // MarkTime(0) == special value (after last access)
    static int MarkTime() { return getInstance() ->m_MarkTime; }
    static void setMarkTime( int value ) { getInstance() ->m_MarkTime = value; }
    static int viewMode() { return getInstance() ->m_viewMode; }
    static void setViewMode( int mode ) { getInstance() ->m_viewMode = static_cast<ViewMode>( mode ); }
    static int sortOrder() { return getInstance() ->m_sortOrder; }
    static void setSortOrder( int order ) { getInstance() ->m_sortOrder = static_cast<SortOrder>( order ); }
    static bool showAA() { return getInstance() ->m_showAA; }
    static void setShowAA( bool on ) { getInstance() ->m_showAA = on; }
    static int afterShowNum() { return getInstance() ->m_afterShowNum; }
    static void setAfterShowNum( int value ) { getInstance() ->m_afterShowNum = value; }
    static int preShowNum() { return getInstance() ->m_preShowNum; }
    static void setPreShowNum( int value ) { getInstance() ->m_preShowNum = value; }
    static bool usePart() { return getInstance()->m_usePart; }
    static void setUsePart( bool value ) { getInstance()->m_usePart = value; }
    static QStringList& partMimeList() { return getInstance()->m_partMimeList; }
    static void setPartMimeList( const QStringList value ) { getInstance()->m_partMimeList = value; }
    static void setPartMimeList( const QString& value )
        { getInstance()->m_partMimeList = QStringList::split( ',', value ); }
};

#endif
