/**************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto , (c)2004 by 421                 *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAPARMISC_H
#define KITAPARMISC_H

class QMutex;
class QTextCodec;
class QDateTime;
class QCp932Codec;
class KURL;

namespace DOM
{
class HTMLDocument;
class Element;
} 

struct RESDAT;

/* mode */
enum{
PARSEMODE_DOM,
PARSEMODE_HTML,
PARSEMODE_TEXT
};

namespace Kita
{
   
class ParseMisc
    {
	static QMutex m_codexMutex;
	static QCp932Codec* m_qcpCodec;
	static QTextCodec* m_utf8Codec;

      public:

	/* Text codec */
	static QString qcpToUnicode( const QString& str );
	static QString utf8ToUnicode( const QString& str );

	
	/* parsing functions */
	static void parseTITLEdat(int mode,DOM::HTMLDocument& hdoc, int num,
	    bool showMailAddress,const RESDAT& resdat,DOM::Element &titlenode,QString& titletext);

	static void parseTITLEdatText(int mode,int num,bool showMailAddress,
				      const RESDAT& resdat,QString& titletext);
	
	static void parseBODYdat(int mode,const QString &rawStr, DOM::HTMLDocument& hdoc,
				 bool showAA, DOM::Element &bodynode, QString& bodytext);

	static void parseBODYdatText(int mode,const QString &rawStr,QString& bodytext);

	static QString ResDatToHtml(const RESDAT& resdat, int num, bool showAddr);
	static QString DatToHtml(const QString& rawData, int num, bool showAddr );
	
	/* utils */
	static bool parseResAnchor(const QChar *cdat,const unsigned int length,
				   QString& linkstr,int* refNum,unsigned int& pos);
	static QString parseSpecialChar(const QChar *cdat, unsigned int& pos );
	static void parseDateId( const QString& str,QString &idstr,
				 QString &dateIdstr, QDateTime &dTime);
	static bool parseResDat(RESDAT& resdat, QString& subject);
	static bool parseLink( const QChar *cdat, const unsigned int length,
	    QString& linkstr, QString& linkurl, unsigned int& pos );
	static KURL parseURL( const KURL& url , QString& refstr );
	static KURL parseURLonly( const KURL& url );
	
	/*-------------------------*/
	
      private:
	
	static bool createResAnchor(int mode,const QString &rawStr, DOM::HTMLDocument& hdoc ,
	    DOM::Element &bodynode, QString& bodytext,
	    const QChar *chpt, unsigned int &i, unsigned int &index, QString& lineStr );
	
	static int isEqual( const QChar *cdat, const QString& str);
	
    };

}

#endif

