/***************************************************************************
 *   Copyright (C) 2004 by Kita Developers                                 *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef KITASIGNALCOLLECTION_H
#define KITASIGNALCOLLECTION_H

#include <kparts/browserextension.h>

#include <qobject.h>

namespace Kita
{
    /**
    @author Hideki Ikemoto
    */
    class SignalCollection : public QObject
    {
        Q_OBJECT
        
        static SignalCollection* instance;
        
        SignalCollection();
        ~SignalCollection();
    public:
        static SignalCollection* getInstance();
    
    signals:
        void openURLRequest( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
        void writeSucceeded();
        void bookmarked( const QString& datURL, bool on );
        void favoritesUpdated();

	/* to: KitaMainWindow, KitaSubjectTabWidget */
	void switchSubjectView();
	
	/* to : KitaSubjectTabWidget */
        void openBoardRequested( const QString& boardURL, bool withNewTab );
	
	/* to : KitaSubjectView, FavoriteListView */
	void updateSubjectTab( const KURL& url );

	/* to : KitaThreadTabWidget */
	void updateThreadTab( const KURL& url );
	void closeThreadTab( const KURL& url );
	void closeCurrentThreadTab();
	
	/* to : KitaMainWindow */
	void setMainURLLine( const KURL& url );
	void setMainCaption( const QString& captionStr );
	void setMainStatusbar( const QString& statusStr );
	
	/* from: KitaMainWindow, KitaNavi, KitaWriteDialog */
	/* to  : KitaHTMLPart                              */
	void windowDeactivated();
	void kitaIsActive();	

	/* from: KitaHTMLPart                              */
	/* to  : KitaMainWindow, KitaNavi, KitaWriteDialog */
	/* see also KitaHTMLPart::slotOnURL                */
	void isKitaActive();

	/* to : KitaHTMLPart */
	void redrawHTMLPart( const KURL& url, bool force );
	void redrawAllHTMLPart( bool force );
	void setFontOfHTMLPart();
    };

}

#endif
