/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITATHREAD_H
#define KITATHREAD_H

#include <qobject.h>
#include <qxml.h>
#include <qdict.h>

#include <stdio.h>

namespace KIO
{
    class Job;
}

class KURL;

namespace Kita
{
    /**
    @author Hideki Ikemoto
    */
    class Thread
    {
        Thread( const QString& datURL, const QString& threadName = QString::null );

    protected:
        Thread();

    public:
        ~Thread();

        const QString& datURL() const;
        const QString url() const;
        const QString datID() const;
        const QString& name() const;
        void setResNum( int resNum );
        int resNum() const;
        const QString& boardName() const;
        const QString boardURL() const;
        const QString boardID() const;

        static Thread* getByURL( const QString& datURL );
	static Thread* getByURLNew( const KURL& datURL );
        static void setName( const QString& datURL, const QString& threadName );
        static void replace( const QString& fromURL, const QString& toURL );
    private:
        QString m_datURL;
        QString m_threadName;
        static QDict<Thread>* m_threadDict;
    };

    class NullThread : public Thread
    {
    public:
        NullThread();
        ~NullThread();
    };
}

#endif
