/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kita.h"

#include <config.h>

#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "libkita/kitaconfig.h"

static const char *description =
    I18N_NOOP("Kita - 2ch client for KDE");

static const char *version = VERSION;

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    { "boardlist <boardlist>", I18N_NOOP( "board list's URL." ), "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html" }, 
    { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    KAboutData about("kita", I18N_NOOP("Kita"), version, description,
                     KAboutData::License_GPL, "(C) 2003-2004 Kita Developers", 0, 0, "ikemo@users.sourceforge.jp");
    about.addAuthor( "Hideki Ikemoto", I18N_NOOP("maintainer, initial code"), "ikemo@users.sourceforge.jp" );
    about.addAuthor( "konqueror plugin no hito", I18N_NOOP("konqueror plugin, KDE part"), "ogirin@users.sourceforge.jp");
    about.addAuthor( "421", I18N_NOOP("kitanavi, threadview's improvement") );
    about.addAuthor( "Toshihiko Okada", I18N_NOOP("improvements"), "tossi@users.sourceforge.jp");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
    KitaConfig::setBoardListURL( QString( args->getOption( "boardlist" ) ) );

    // see if we are starting with session management
    if (app.isRestored())
        RESTORE(KitaMainWindow)
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            KitaMainWindow *widget = new KitaMainWindow;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                KitaMainWindow *widget = new KitaMainWindow;
                widget->show();
                widget->load(args->url(i));
            }
        }
        args->clear();
    }

    return app.exec();
}
