/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITA2CH_H_
#define _KITA2CH_H_

#include <qptrlist.h>

/**
 *
 * Hideki Ikemoto
 **/

#include <kurl.h>

#include <qdatetime.h>
#include <qptrlist.h>

namespace Kita
{
    class Thread;
    class Board;

    enum K2chResultCode {
        K2ch_Unknown,
        K2ch_True,
        K2ch_False,
        K2ch_Error,
        K2ch_Check,
        K2ch_Cookie
    };

    class WriteResult
    {

        QString m_str;
    public:
        WriteResult( QString str );
        QString toString() const { return m_str; }
        K2chResultCode code() const;
        QString message() const;
        QString title() const;
    };

    struct PostInfo
    {
        PostInfo()
        {
            bbscgi = "/test/bbs.cgi";
            submit = "%91%53%90%d3%94%43%82%f0%95%89%82%a4%82%b1%82%c6%82%f0%8f%b3%91%f8%82%b5%82%c4%8f%91%82%ab%8d%9e%82%de";
        };
        QString host;
        QString bbscgi;
        QString name;
        QString mail;
        QString body;
        QString bbs;
        QString key;
        QString time;
        QString submit;
        QString cookie;
        bool check() const;
        QString postStr();
    };
}

#endif
