/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto , 2004 by 421                    *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAHTMLPART_H
#define KITAHTMLPART_H

#include <khtml_part.h>
#include <qtextbrowser.h>

/* mode */
enum {
    HTMLPART_MODE_KHTML, /* This part is not initialized. This part works as just KHTMLPart */

    HTMLPART_MODE_MAINPART,/* on main window */
    HTMLPART_MODE_NAVI,    /* on Kita Navi   */
    HTMLPART_MODE_POPUP    /* on popup       */
};


class KitaHTMLPart;
class KitaDomTree;
class KitaThreadView;
class KPopupMenu;
class KURL;

namespace Kita
{
    class ResPopup;
}

namespace DOM
{
    class Node;
}


/*-------------------------------------------------------------*/

class KitaHTMLPart : public KHTMLPart
{
    Q_OBJECT

    KitaDomTree* m_domtree;
    Kita::ResPopup* m_popup;

    /* basic information */
    int m_mode;
    KURL m_datURL;
    bool m_updatedKokoyon;


    /* cache */
    bool m_firstReceive;
    int m_centerNum;

    /* goto anchor */
    QStringList m_anchorStack;

    /* mouse event */
    bool m_pushctrl;
    bool m_pushmidbt;
    bool m_pushrightbt;

    /* search */
    DOM::Node m_findNode;
    int m_findPos;
    int m_find_y;

    /* res popup */
    bool m_multiPopup;
    bool m_kitaIsActive;


public:

    KitaHTMLPart( QWidget* parent, const char* name = 0 );
    ~KitaHTMLPart();
    bool setup( int mode , const KURL& url );
    const int getMode() const;

    /* rendering */
    void showResponses( int startnum, int endnum );
    void parseResponses( int startnum, int endnum );
    void showAll();
    void insertBeltNode( const QString& idstr );
    void insertHeaderNode( const QString& str );
    void insertFooterNode( const QString& str );
    void updateScreen( bool showHeaderEtc, bool clock);
    void setInnerHTML( const QString& innerHTML );

    /* cache */
    bool load( int centerNum );
    bool reload();

    /* goto anchor */
    bool gotoAnchor( const QString& anc, bool pushPosition );

    /* search */
    bool findText( const QString &query, bool reverse );


public slots:

    /* rendering */
    void slotRedrawHTMLPart( const KURL& datURL, bool force );
    void slotRedrawAllHTMLPart( bool force );
    void slotSetFontOfHTMLPart();

    /* cache */
    void slotReceiveData();
    void slotFinishLoad();

    /* goto anchor */
    void slotGotoKokoyon();
    void slotGobackAnchor();

    /* Tugi100, Mae100 etc.  */
    void slotClickTugi100();
    void slotClickNokori();
    void slotClickGotoFooter();
    void slotClickMae100();
    void slotClickMaeZenbu();
    void slotClickTmpNext100();
    void slotClickShowAll();


private:

    void clearPart();

    /* setup */
    void connectSignals();
    void createHTMLDocument();

    /* goto anchor */
    void pushCurrentPosition();

    /* popup menu */
    void showPopupMenu( const KURL& kurl );

    /* click */
    void clickAnchor(  const KURL& urlin );
    void showWritePopupMenu( const QString& refstr);
    void showIDPopup( const QString& refstr );
    bool showNext100Etc( const QString& refstr );

    /* search */
    void findTextInit();

    /* res popup */
    void showPopup(  const KURL& url, const QString& innerHTML );
    bool startMultiPopup();
    bool isMultiPopupMode();
    void hidePopup();
    void deletePopup();
    bool isUnderMouse( int mrgwd, int mrght );
    bool showSelectedDigitPopup();

protected:

    /* mouse event */
    virtual void khtmlMousePressEvent( khtml::MousePressEvent* e );


private slots:

    /* click */
    void slotOpenURLRequest( const KURL&, const KParts::URLArgs& );

    /* res popup */
    void slotLeave();
    void slotVSliderReleased();
    void slotHSliderReleased();
    void slotHideChildPopup();
    void slotKitaIsActive();
    void slotOnURL( const QString& url );


signals:

    void openWriteDialog( QString );
    void openURLRequest( const KURL& url, const KParts::URLArgs &args = KParts::URLArgs() );
    void redrawHTMLPart( const KURL& url, bool force );

    /* cache */
    void receiveData();
    void finishReload();

    /* res popup */
    void hideChildPopup();
    void isKitaActive();
};



/*---------------------------------------------------*/
/*---------------------------------------------------*/
/*---------------------------------------------------*/


namespace Kita
{
    class ResPopup : public QFrame
    {
        Q_OBJECT

        KitaHTMLPart* m_htmlPart;
        QTextBrowser* m_textBrowser;

    public:
        ResPopup( KHTMLView* view, const KURL& datURL );
        ~ResPopup();
        void setText( const QString& str );
        void adjustSize();
        void adjustPos();
        void moveMouseAbove();

    signals:
        void hideChildPopup();
    };
}



#endif
