
#ifndef __KITA_THREAD_PARTS_H__
#define __KITA_THREAD_PARTS_H__

#include <kparts/browserextension.h>
#include <kparts/genericfactory.h>
#include <kparts/part.h>

#include "kitathreadview.h"

class KitaThreadPart;
class KitaThreadBrowserExtension;

class KitaThreadPart : public KParts::ReadOnlyPart
{
    Q_OBJECT
public:
    KitaThreadPart( QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name, const QStringList& args );

    virtual ~KitaThreadPart();

    static KAboutData * createAboutData(); //needed by GenericFactory
    void setupActions();

    KParts::BrowserExtension *browserExtension() const;

signals:
    void onURL( const QString& url );
public slots:
    virtual bool openURL( const KURL& url );
    virtual bool closeURL();

protected:
    virtual bool openFile() { return false; };
    virtual void guiActivateEvent ( KParts::GUIActivateEvent *event );

protected slots:
    void slotOpenURLResult();

protected:
    KitaThreadView * m_threadview;
    KitaThreadBrowserExtension * m_extension;
};

class KitaThreadBrowserExtension : public KParts::BrowserExtension
{
    Q_OBJECT
public:
    KitaThreadBrowserExtension( KitaThreadPart * parent );
    virtual ~KitaThreadBrowserExtension();
};

#endif 
// vim:sw=4
