/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITAWRITEDIALOG_H_
#define _KITAWRITEDIALOG_H_

#include <qwidget.h>
#include <kio/job.h>
#include "kitawritedialogbase.h"
#include "kita2ch.h"

template <class type> class QPtrList;
class KitaWriteDialogPrivate;
class KitaWriteDialog;
class KitaHTMLPart;

namespace Kita
{
    class Access;
}

/**
 * 
 * Hideki Ikemoto
 **/
class KitaWriteDialog : public KitaWriteDialogBase
{
    Q_OBJECT
public:
    KitaWriteDialog( const KURL& datURL, QWidget* parent = 0, const char* name = 0 );
    virtual ~KitaWriteDialog();
    const QString name() const;
    const QString mail() const;
    const QString body() const;

    virtual bool error() { return false; };

    static KitaWriteDialog* open( const Kita::PostInfo& info, const KURL& datURL, QWidget* parent );

public slots:
    void postMessage();

private slots:
    void slotCurrentChanged ( QWidget * w );

signals:
    void postStarted( KIO::Job*, const Kita::PostInfo& );
    void postFinished( KIO::Job* );
    void postResponse( const QString& response, const KURL& bbscgi = KURL() );

protected:
    Kita::PostInfo m_postInfo;
    void windowActivationChange( bool );

protected slots:
    virtual void reject();

private:
    void fetchPostInfo( Kita::PostInfo* storage ) const;

    QCString m_array;
    bool m_error;
    static KitaWriteDialogPrivate* s_private;
    KitaHTMLPart *m_preview;
    int m_resnum;
    KURL m_datURL;

private slots:
    void slotRecieveData( KIO::Job*, const QByteArray& );
    void slotPostFinished( KIO::Job* );
    void slotIsKitaActive();    

signals:
    void windowDeactivated();
    void isKitaActive();
    void kitaIsActive();          

};

class KitaWriteDialogPrivate
{
public:
    QPtrList<KitaWriteDialog> m_heaplist;
};
#endif
