/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITAPREF_H_
#define _KITAPREF_H_

#include <kdialogbase.h>
#include <qframe.h>

#include "kitafontprefbase.h"
#include "kitacolorprefbase.h"
#include "asciiartprefbase.h"
#include "uiprefbase.h"
#include "debugprefbase.h"

#include "libkita/favoritethreads.h"
#include "libkita/threadinfo.h"
#include "libkita/favoriteboards.h"

class KitaFontPrefPage;
class KitaColorPrefPage;
class DebugPrefPage;

namespace Kita
{
    class AsciiArtPrefPage;
    class UIPrefPage;
    class AbonePrefPage;
}

class KitaPreferences : public KDialogBase
{
    Q_OBJECT

public:
    KitaPreferences();

protected:
    virtual void slotApply();

private:
    KitaFontPrefPage* m_fontPage;
    KitaColorPrefPage* m_colorPage;
    Kita::AsciiArtPrefPage* m_asciiArtPage;
    Kita::UIPrefPage* m_uiPage;
    Kita::AbonePrefPage* m_abonePage;
    DebugPrefPage* m_debugPage;

private slots:
    void slotChanged();
    virtual void slotOk();

signals:
    void fontChanged( const QFont& );
};

class KitaFontPrefPage : public KitaFontPrefBase
{
    Q_OBJECT

    bool m_threadFontchanged;

public:
    KitaFontPrefPage( QWidget* parent = 0 );
    void apply();

public slots:
    void slotFontButtonClicked();
    void slotThreadFontButtonClicked();

private:
    void updateButtons();

signals:
    void fontChanged( const QFont& );
    void setFontOfHTMLPart();
    void changed();
};

class KitaColorPrefPage : public KitaColorPrefBase
{
    Q_OBJECT

public:
    KitaColorPrefPage( QWidget* parent = 0 );
    void apply();

signals:
    void changed();
};

class DebugPrefPage : public DebugPrefBase
{
    Q_OBJECT

public:
    DebugPrefPage( QWidget* parent = 0 );

public slots:
    void replace();
};

namespace Kita
{
    class AsciiArtPrefPage : public AsciiArtPrefBase
    {
        Q_OBJECT
    public:
        AsciiArtPrefPage( QWidget* parent = 0 );
    public slots:
        void commit();

    signals:
        void changed();
    };

    class UIPrefPage : public UIPrefBase
    {
        Q_OBJECT
    public:
        UIPrefPage( QWidget* parent = 0 );
        void apply();

    signals:
        void changed();
    };
}

#endif // _KITAPREF_H_
