/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITATHREADLISTVIEW_H
#define KITATHREADLISTVIEW_H

#include "threadlistviewbase.h"

#include <klistview.h>

enum ThreadListViewRows {
    Col_Mark,
    Col_ID,
    Col_Icon,
    Col_Subject,
    Col_ResNum,
    Col_Read,
    Col_Unread,
    Col_Since,
    Col_Board,
    Col_DatURL,
    Col_MarkOrder
};

namespace Kita
{
    class Thread;
    /**
    @author Hideki Ikemoto
    */
    class ThreadListView : public Kita::ThreadListViewBase
    {
        Q_OBJECT

    public:
        ThreadListView( QWidget* parent = 0, const char *name = 0 );
        ~ThreadListView();

    protected:
        QStringList m_prevquery;
        unsigned m_nextHitIndex;
        QValueList<KListViewItem *> m_hitList;

        void insertSearchCombo();
        QStringList parseSearchQuery( const QString& input );
        void searchNext( const QStringList& input );
        void searchAll( const QStringList& query );

    protected slots:
        void slotHideButton( bool on );
        void slotMouseButtonClicked( int, QListViewItem* );

    private slots:
        void slotSearchButton();
    
    signals:
        /**
        * @param datURL ɽ륹datURL
        */
        void showThreadRequested( const QString& datURL, bool withNewTab );
        void bookmarked( const QString& datURL, bool on );
    };

    class ThreadListViewItem : public KListViewItem
    {
    public:
        ThreadListViewItem( QListView* parent ) : KListViewItem( parent ) {};
        virtual ~ThreadListViewItem() {};

        virtual int compare( QListViewItem* i, int col, bool ascending ) const;
    };
}

#endif
