# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

require 'singleton'

class Config
  include Singleton

  def initialize
    @config = KDE::SimpleConfig.new(ENV['HOME'] + "/.kita/config")
  end

  def user_id
    @config.setGroup("Account")
    @config.readEntry("UserId")
  end

  def user_id=(user_id)
    @config.setGroup("Account")
    @config.writeEntry("UserId", user_id)
    @config.sync
  end

  def password
    @config.setGroup("Account")
    @config.readEntry("Password")
  end

  def password=(password)
    @config.setGroup("Account")
    @config.writeEntry("Password", password)
    @config.sync
  end

  def default_name
    @config.setGroup("Write")
    @config.readEntry("DefaultName")
  end

  def default_name=(name)
    @config.setGroup("Write")
    @config.writeEntry("DefaultName", name)
    @config.sync
  end

  def default_mail
    @config.setGroup("Write")
    @config.readEntry("DefaultMail")
  end

  def default_mail=(mail)
    @config.setGroup("Write")
    @config.writeEntry("DefaultMail", mail)
    @config.sync
  end

  def kotehan
    @config.setGroup("Write")
    @config.readListEntry("Kotehan")
  end

  def kotehan=(list)
    @config.setGroup("Write")
    @config.writeEntry("Kotehan", list)
    @config.sync
  end
end
