# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class PreferenceDialog < KDE::DialogBase
  slots 'save_config()'

  def initialize(parent)
    super(KDE::DialogBase::IconList, 0, parent, "settings")

    @general_vbox = addVBoxPage("General", nil, KDE::SmallIcon("configure", 32))

    @account_vbox = addVBoxPage("Account", nil, KDE::SmallIcon("identity", 32))
    @account_page = AccountPage.new(@account_vbox)

    @write_vbox = addVBoxPage("Write", nil, KDE::SmallIcon("edit", 32))
    @write_page = WritePage.new(@write_vbox)

    connect(self, SIGNAL("okClicked()"), self, SLOT("save_config()"))

    load_config
  end

  def load_config
    config = Config.instance
    @account_page.id_line.text = config.user_id
    @account_page.password_line.text = config.password
    @account_page.autologin_check.setChecked(config.auto_login)
    @write_page.default_name_line.text = config.default_name
    @write_page.default_mail_line.text = config.default_mail
    @write_page.kotehan_edit.text = config.kotehan.join("\n")
  end

  def save_config
    id = @account_page.id_line.text
    password = @account_page.password_line.text
    auto_login = @account_page.autologin_check.checked
    default_name = @write_page.default_name_line.text
    default_mail = @write_page.default_mail_line.text
    kotehan = @write_page.kotehan_edit.text.split("\n").grep(/^.+$/)

    config = Config.instance
    config.user_id = id
    config.password = password
    config.auto_login = auto_login
    config.default_name = default_name
    config.default_mail = default_mail
    config.kotehan = kotehan
  end
end
