/*
 * Copyright (C) 2001 Hideki Ikemoto <ikemo@wakaba.jp>
 */

#include "kita.h"
#include "pref.h"
#include "kitathreadview.h"
#include "kitasubjectview.h"
#include "kitaboardview.h"
#include "kitacacheinfo.h"

#include <qdragobject.h>
#include <kprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qtextcodec.h>

#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kkeydialog.h>
#include <kaccel.h>
#include <kio/netaccess.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kurl.h>
#include <kurlrequesterdlg.h>
#include <krun.h>
#include <kstandarddirs.h>

#include <kedittoolbar.h>

#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>

Kita::Kita()
    : KDockMainWindow( 0, "Kita" ),
    ///      m_view(new KitaView(this)),
    m_printer(0)
{
  // accept dnd
  setAcceptDrops(true);

  // setup view, dock
  setupView();

  // then, setup our actions
  setupActions();

  // load cache
  loadCache();
  
  // and a status bar
  statusBar()->show();
  
  // apply the saved mainwindow settings, if any, and ask the mainwindow
  // to automatically save settings if changed: window size, toolbar
  // position, icon size, etc.
  setAutoSaveSettings();

  // allow the view to change the statusbar and caption
  connect(m_threadView, SIGNAL(signalChangeStatusbar(const QString&)),
          this,   SLOT(changeStatusbar(const QString&)));
  connect(m_boardView, SIGNAL(signalLoadBoard(const KURL&, const QString&)),
          m_subjectView, SLOT(slotLoadBoard(const KURL&, const QString&)));
  connect(m_subjectView, SIGNAL(signalShowThread(const Kita2ch::Board&, const Kita2ch::Thread&)),
          m_threadView, SLOT(slotShowThread(const Kita2ch::Board&, const Kita2ch::Thread&)));
  //    connect(m_view, SIGNAL(signalChangeCaption(const QString&)),
  //            this,   SLOT(changeCaption(const QString&)));
  connect(m_threadView, SIGNAL(setVestedNum(const KURL&, int)), SLOT(slotSetVestedNum(const KURL&, int)));
  m_boardView->loadBoardList();
}


Kita::~Kita()
{
  saveCache();
}

void Kita::load(const KURL& url)
{
  QString target;
  // the below code is what you should normally do.  in this
  // example case, we want the url to our own.  you probably
  // want to use this code instead for your app

#if 0
  // download the contents
  if (KIO::NetAccess::download(url, target)) {
    // set our caption
    setCaption(url);

    // load in the file (target is always local)
    loadFile(target);

    // and remove the temp file
    KIO::NetAccess::removeTempFile(target);
  }
#endif

  setCaption(url.url());
  //    m_view->openURL(url);
}

void Kita::setupActions()
{
  KStdAction::openNew(this, SLOT(fileNew()), actionCollection());
  KStdAction::open(this, SLOT(fileOpen()), actionCollection());
  KStdAction::save(this, SLOT(fileSave()), actionCollection());
  KStdAction::saveAs(this, SLOT(fileSaveAs()), actionCollection());
  KStdAction::print(this, SLOT(filePrint()), actionCollection());
  KStdAction::quit(kapp, SLOT(quit()), actionCollection());

  m_toolbarAction = KStdAction::showToolbar(this, SLOT(optionsShowToolbar()), actionCollection());
  m_statusbarAction = KStdAction::showStatusbar(this, SLOT(optionsShowStatusbar()), actionCollection());

  KStdAction::keyBindings(this, SLOT(optionsConfigureKeys()), actionCollection());
  KStdAction::configureToolbars(this, SLOT(optionsConfigureToolbars()), actionCollection());
  KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());

  // this doesn't do anything useful.  it's just here to illustrate
  // how to insert a custom menu and menu item
  /*    KAction *custom = new KAction(i18n("Cus&tom Menuitem"), 0,
                                    this, SLOT(optionsPreferences()),
                                    actionCollection(), "custom_action");*/

  KAction *loadBoardList = new KAction(i18n("Load BoardList"), 0,
                                       m_boardView, SLOT(loadBoardList()),
                                       actionCollection(), "load_board_list");
  createGUI();
}

void Kita::saveProperties(KConfig *config)
{
  // the 'config' object points to the session managed
  // config file.  anything you write here will be available
  // later when this app is restored

  //    if (m_view->currentURL() != QString::null)
  //        config->writeEntry("lastURL", m_view->currentURL());
}

void Kita::readProperties(KConfig *config)
{
  // the 'config' object points to the session managed
  // config file.  this function is automatically called whenever
  // the app is being restored.  read in here whatever you wrote
  // in 'saveProperties'

  //    QString url = config->readEntry("lastURL");

  //    if (url != QString::null)
  //        m_view->openURL(KURL(url));
}

void Kita::dragEnterEvent(QDragEnterEvent *event)
{
  // accept uri drops only
  event->accept(QUriDrag::canDecode(event));
}

void Kita::dropEvent(QDropEvent *event)
{
  // this is a very simplistic implementation of a drop event.  we
  // will only accept a dropped URL.  the Qt dnd code can do *much*
  // much more, so please read the docs there
  QStrList uri;

  // see if we can decode a URI.. if not, just ignore it
  if (QUriDrag::decode(event, uri)) {
    // okay, we have a URI.. process it
    QString url, target;
    url = uri.first();

    // load in the file
    load(KURL(url));
  }
}

void Kita::fileNew()
{
  // this slot is called whenever the File->New menu is selected,
  // the New shortcut is pressed (usually CTRL+N) or the New toolbar
  // button is clicked

  // create a new window
  (new Kita)->show();
}

void Kita::fileOpen()
{
  // this slot is called whenever the File->Open menu is selected,
  // the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
  // button is clicked
  //    KURL url = KURLRequesterDlg::getURL(QString::null, this, i18n("Open Location") );
  //    if (!url.isEmpty())
  //        m_view->openURL(url);
}

void Kita::fileSave()
{
  // this slot is called whenever the File->Save menu is selected,
  // the Save shortcut is pressed (usually CTRL+S) or the Save toolbar
  // button is clicked

  // save the current file
}

void Kita::fileSaveAs()
{
  // this slot is called whenever the File->Save As menu is selected,
  KURL file_url = KFileDialog::getSaveURL();
  if (!file_url.isEmpty() && !file_url.isMalformed()) {
    // save your info, here
  }
}

void Kita::filePrint()
{
  // this slot is called whenever the File->Print menu is selected,
  // the Print shortcut is pressed (usually CTRL+P) or the Print toolbar
  // button is clicked
  /*    if (!m_printer) m_printer = new KPrinter;
      if (m_printer->setup(this))
      {
          // setup the printer.  with Qt, you always "print" to a
          // QPainter.. whether the output medium is a pixmap, a screen,
          // or paper
          QPainter p;
          p.begin(m_printer);
   
          // we let our view do the actual printing
          QPaintDeviceMetrics metrics(m_printer);
          m_view->print(&p, metrics.height(), metrics.width());
   
          // and send the result to the printer
          p.end();
      }*/
}

void Kita::optionsShowToolbar()
{
  // this is all very cut and paste code for showing/hiding the
  // toolbar
  if (m_toolbarAction->isChecked())
    toolBar()->show();
  else
    toolBar()->hide();
}

void Kita::optionsShowStatusbar()
{
  // this is all very cut and paste code for showing/hiding the
  // statusbar
  if (m_statusbarAction->isChecked())
    statusBar()->show();
  else
    statusBar()->hide();
}

void Kita::optionsConfigureKeys()
{
  KKeyDialog::configureKeys(actionCollection(), "kitaui.rc");
}

void Kita::optionsConfigureToolbars()
{
  // use the standard toolbar editor
  saveMainWindowSettings( KGlobal::config(), settingsGroup() );
  KEditToolbar dlg(actionCollection());
  connect(&dlg, SIGNAL(newToolbarConfig()), this, SLOT(newToolbarConfig()));
  dlg.exec();
}

void Kita::newToolbarConfig()
{
  // this slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
  // recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
  createGUI();
  applyMainWindowSettings( KGlobal::config(), settingsGroup() );
}

void Kita::optionsPreferences()
{
  // popup some sort of preference dialog, here
  KitaPreferences dlg;
  
  connect(&dlg, SIGNAL(signalFontChanged(QFont&)), m_threadView, SLOT(slotFontChanged(QFont&)));
  connect(&dlg, SIGNAL(signalFontChanged(QFont&)), m_subjectView, SLOT(slotFontChanged(QFont&)));
  connect(&dlg, SIGNAL(signalFontChanged(QFont&)), m_boardView, SLOT(slotFontChanged(QFont&)));
  if (dlg.exec()) {
    // redo your settings
  }
}

void Kita::changeStatusbar(const QString& text)
{
  // display the text on the statusbar
  statusBar()->message(text);
}

void Kita::changeCaption(const QString& text)
{
  // display the text on the caption
  setCaption(text);
}

void Kita::setupView()
{
  KDockWidget* mainDock;
  mainDock = createDockWidget("main", 0L, 0L, i18n("main"));
  m_threadView = new KitaThreadView(mainDock);
  mainDock->setWidget(m_threadView);
  mainDock->setDockSite(KDockWidget::DockFullSite);
  mainDock->setEnableDocking(KDockWidget::DockNone);
    connect( m_threadView, SIGNAL( openURLRequest(const KURL&, const KParts::URLArgs&) ),
		    	   SLOT( slotOpenURLRequest(const KURL&, const KParts::URLArgs&) ) );

  KDockWidget* subjectDock;
  subjectDock = createDockWidget("subject", 0L, 0L, i18n("subject"));
  m_subjectView = new KitaSubjectView(subjectDock);
  subjectDock->setWidget(m_subjectView);
  subjectDock->setDockSite(KDockWidget::DockFullSite);

  KDockWidget* boardDock;
  boardDock = createDockWidget("board", 0L, 0L, i18n("board"));
  m_boardView = new KitaBoardView(boardDock);
  boardDock->setWidget(m_boardView);
  boardDock->setDockSite(KDockWidget::DockFullSite);

  setView(mainDock);
  setMainDockWidget(mainDock);

  boardDock->manualDock(mainDock, KDockWidget::DockLeft, 20);
  subjectDock->manualDock(mainDock, KDockWidget::DockTop);
}

void Kita::slotOpenURLRequest(const KURL& url, const KParts::URLArgs&)
{
  new KRun(url);
}

void Kita::slotSetVestedNum(const KURL& threadURL, int resCount)
{
  KitaCacheInfo::getInstance()->setVestedNum(threadURL, resCount);
}

void Kita::loadCache()
{
  KitaCacheInfo* cache = KitaCacheInfo::getInstance();
  QString cacheConfigPath = locateLocal("appdata", "cache");
  QFile file(cacheConfigPath);
  if( file.open(IO_ReadOnly) ) {
    QDataStream stream(&file);
    stream >> *cache;
  }
}

void Kita::saveCache()
{
  KitaCacheInfo* cache = KitaCacheInfo::getInstance();
  QString cacheConfigPath = locateLocal("appdata", "cache");
  QFile file(cacheConfigPath);
  if( file.open(IO_WriteOnly) ) {
    QDataStream stream(&file);
    stream << *cache;
  }
}

#include "kita.moc"
