/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kio/netaccess.h>

#include <qfile.h>
#include <qtextcodec.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <klistview.h>

#include "kitaboardview.h"
#include "kita.h"


KitaBoardView::KitaBoardView(QWidget *parent, const char *name)
    : KitaBoardViewBase(parent, name)
{
  boardList->setSorting(-1);
  boardList->addColumn("name");
  connect(boardList, SIGNAL(executed(QListViewItem*)), SLOT(slotLoadBoard(QListViewItem*)));
}

KitaBoardView::~KitaBoardView()
{}

void KitaBoardView::loadBoardList()
{
  QString tmpFile;
  QString url = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
  if(KIO::NetAccess::download(url, tmpFile))
  {
    QFile file(tmpFile);
    QTextStream stream(&file);
    stream.setCodec(QTextCodec::codecForName("Shift_JIS"));

    if(file.open(IO_ReadOnly))
    {
      QString html = stream.read();

      /* boardList*/
      QStringList lines = QStringList::split("\n", html);
      QStringList::iterator it;

      QRegExp category_r("<BR><BR><B>(.*)</B><BR>");
      QRegExp board_r("<A HREF=(.*)>(.*)</A>");
      QRegExp url_2ch("http://.*\\.2ch\\.net/.*");
      QRegExp url_bbspink("http://.*\\.bbspink\\.com/.*");
      QRegExp url_www_2ch("http://www\\.2ch\\.net/.*");
      
      KListViewItem* current_category = 0;
      KListViewItem* current_board = 0;
      for(it = lines.begin(); it != lines.end(); ++it)
      {
        if(category_r.search(*it) != -1)
        {
          QString category = category_r.cap(1);
          
          KListViewItem* old_category = current_category;
          current_category = new KListViewItem(boardList, old_category, category);
          
          if( old_category != 0 && old_category->childCount() == 0 ) {
            // useless category. remove it!
            delete old_category;
          }
        }
        else if(board_r.search(*it) != -1)
        {
          QString board_url = board_r.cap(1);
          QString board_title = board_r.cap(2);

          if( current_category != 0 &&
              (url_2ch.search(board_url) != -1 || url_bbspink.search(board_url) != -1) &&
              url_www_2ch.search(board_url) == -1 )
          {
            current_board = new KListViewItem(current_category, current_board, board_title, board_url);
          }
        }
      }
      if ( current_category != 0 && current_category->childCount() == 0 ) {
        delete current_category;
      }
    }
  }
}

void KitaBoardView::slotLoadBoard(QListViewItem* item)
{
  QString boardName = item->text(0);
  KURL url = item->text(1);
  
  emit signalLoadBoard(url, boardName);
}

void KitaBoardView::slotFontChanged(QFont& font)
{
}
