/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITABOARDVIEW_H_
#define _KITABOARDVIEW_H_

#include <qwidget.h>

#include "kitaboardviewbase.h"

class Kita;
class KURL;

/**
 * 
 * Hideki Ikemoto
 **/
class KitaBoardView : public KitaBoardViewBase
{
  Q_OBJECT

public:
  KitaBoardView(QWidget *parent, const char *name=0);
  ~KitaBoardView();
public slots:
  void loadBoardList();
  void slotLoadBoard(QListViewItem* item);
  void slotFontChanged(QFont& font);
signals:
  void signalLoadBoard(const KURL& url, const QString& boardName);
};

#endif
