
#ifndef _KITA2CH_H_
#define _KITA2CH_H_

#include <qptrlist.h>

/**
 * 
 * Hideki Ikemoto
 **/

#include <kurl.h>

#include <qptrlist.h>

namespace Kita2ch
{
  class Thread;
  
  class Board
  {
    KURL m_boardURL;
    QString m_boardName;
    QPtrList<Thread> m_threadList;
  public:
    Board();
    Board(const KURL& boardURL, const QString boardName = QString::null);
    ~Board();
    const KURL subjectTxtURL();
    const KURL url();
    const QString name();
    const QString id();
    QPtrList<Thread> getThreadList();
    void refreshChildList();
  };
  
  class Thread
  {
    KURL m_datURL;
    QString m_datID;
    QString m_boardID;
    QString m_threadName;
    int m_resNum;
  public:
    Thread();
    Thread(const KURL& datURL, const QString threadName = QString::null, int resNum = 0);
    ~Thread();
    const KURL datURL();
    const KURL url();
    const QString datID();
    int resNum();
    const QString name() const;
    void setName(QString name) { m_threadName = name; }
    void setResNum(int resNum) { m_resNum = resNum; }
  };
  
  class Comment
  {
    QString m_name;
    QString m_address;
    QString m_dateId;
    QString m_body;
    QString m_subject;
    bool m_isValid;
  public:
    Comment(QString line);
    ~Comment() {}
    QString getName() { return m_name; }
    QString getAddress() { return m_address; }
    QString getDateId() { return m_dateId; }
    QString getBody() { return m_body; }
    QString getSubject() { return m_subject; }
    bool isValid() { return m_isValid; }
    QString toHtml(int num);
  private:
    QString linkedAddress();
    QString linkedBody();
  };
};

#endif
