/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *   linux 󥫥פ餰ο                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qfile.h>
#include <qtextstream.h>
#include <qtextcodec.h>
#include <qlayout.h>
#include <qtoolbutton.h>
#include "qcp932codec.h"
#include <qsjiscodec.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qprogressdialog.h>
#include <qvaluestack.h>

#include <time.h>

#include <kurl.h>
#include <kio/netaccess.h>
#include <kio/slaveconfig.h>
#include <kio/jobclasses.h>
#include <kio/scheduler.h>

#include <khtml_part.h>
#include <khtmlview.h>
#include <dom/html_element.h>
#include <dom/html_inline.h>
#include <dom/html_base.h>

#include <kglobal.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kaction.h>

#include "kitathreadview.h"
#include "kitawritedialog.h"
#include "../kitacacheinfo.h"
#include "kita2ch.h"

#include <qmessagebox.h>

KitaThreadView::KitaThreadView(QWidget *parent, const char *name)
    : KitaThreadViewBase(parent, name)
    , m_parent( parent )
    , m_currentJob( 0 )
    , m_labelMaxLength( 60 )
{
  m_threadPart = new KHTMLPart(threadFrame);
  QHBoxLayout* aLayout = new QHBoxLayout(threadFrame);
  aLayout->addWidget(m_threadPart->view());

  {
    m_threadPart->setStandardFont("Gothic [Mona]");
    m_threadPart->setZoomFactor(120); // 12px;    
#if 0 // provides you with mona font info.
    QString info;
    info +=  view()->font().family();
    info +="\n";
    info +=  QString("size: %1pt %2px\n").arg( view()->font().pointSizeFloat() ).arg( view()->font().pixelSize() );
    QMessageBox::information( 0, "", info );
#endif
  }
  
  {
    SearchButton->setPixmap( SmallIcon("find") );
    HighLightButton->setPixmap( SmallIcon("idea") );
    ReloadButton->setPixmap( SmallIcon("reload") );
  }

  setAcceptDrops( true ); // DND Drop eneble: 2nd stage. - enable on "KitaThreadView" widget and disable on the others(child widgets of "KitaThreadView").
  threadFrame->setAcceptDrops( false ); // don't treat Drop event on child.
  m_threadPart->view()->setAcceptDrops( false ); // don't treat Drop event on child.

  m_threadPart->enableMetaRefresh( false ); //disable <meta refresh="...">


  connect( writeButton, SIGNAL(clicked()), SLOT(slotWriteButtonClicked()));
  connect( m_threadPart, SIGNAL( nodeActivated(const DOM::Node &) ), SLOT( slotDOMNodeActivated(const DOM::Node &) ) );
  connect( m_threadPart, SIGNAL( onURL(const QString&) ), SLOT( slotOnURL(const QString&) ) );
  connect( SearchButton, SIGNAL( clicked() ), SLOT( slotSearchButton() ) );
  connect( SearchCombo, SIGNAL( activated(int) ), SLOT( slotSearchButton() ) );
  connect( HighLightButton, SIGNAL( toggled(bool) ), SLOT( slotHighLightenButton(bool) ) );
  connect( GobackAnchorButton, SIGNAL( clicked() ), SLOT( gobackAnchor() ) );
  connect( ReloadButton, SIGNAL( clicked() ), SLOT( slotReloadButton() ) );

  KParts::BrowserExtension * ext = m_threadPart->browserExtension();
  connect( ext, SIGNAL( openURLRequest(const KURL&, const KParts::URLArgs&) ),
                 SLOT( slotOpenURLRequest(const KURL&, const KParts::URLArgs&) ) );
      		//SIGNAL( openURLRequest(const KURL&, const KParts::URLArgs&) ) );
  connect( ext, SIGNAL( createNewWindow (const KURL&, const KParts::URLArgs&) ),
      		SIGNAL( createNewWindow (const KURL&, const KParts::URLArgs&) ) );
  connect( ext, SIGNAL( setLocationBarURL(const QString &) ),
      		SIGNAL( setLocationBarURL(const QString &) ) );
  connect( ext, SIGNAL( enableAction(const char*, bool) ),
      		SIGNAL( enableAction(const char*, bool) ) );

  connect( ext, SIGNAL( popupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t) ),
      this, SLOT( slotPopupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t) ) );

}

KitaThreadView::~KitaThreadView() {}

QString KitaThreadView::threadSubject() const
{
  return m_thread.name();
}

void KitaThreadView::slotDOMNodeActivated(const DOM::Node &node)
{
  { //process Anchor tags. Anchor tags not proccessed here cause 'emit KParts::BrowserExtention::openURLRequest()'
    DOM::HTMLAnchorElement anchor = node;

    if ( ! anchor.href().isEmpty() )
    {
      printf("  AnchorNodeActivated:: \n" );
    } // end: anchor.href().isEmpty()
  } // end of Anchor tags. 
}

//void KitaThreadView::slotShowThread(const KURL& _datURL, const KURL& _boardURL, const QString& boardName)
void KitaThreadView::slotShowThread(const Kita2ch::Board& board, const Kita2ch::Thread& thread)
{
  { //reset member variables associated with a thread.
    m_prevquery = "";
    m_nextHit = 0;
    m_hitcount = 0;
    m_writeResult = "";
    m_threadData = "";
    m_contents = "";
    m_pointStack.clear();
  }

  m_board = board;
  m_thread = thread;
  if ( m_thread.datURL().protocol() != "k2ch" ) { 
    KIO::SlaveConfig::self()->setConfigData("http", m_thread.datURL().host() ,
                                          "UserAgent", "Monazilla/1.00 (Kita/0.3)");
  }
    
  KIO::TransferJob* job = KIO::get(m_thread.datURL(), true, true);
  m_currentJob = job;

  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotReceiveThreadData(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotThreadResult(KIO::Job*)));
  connect(job, SIGNAL(redirection(KIO::Job *, const KURL&) ), SLOT(slotRedirection(KIO::Job *, const KURL&) ) );

  // use 'HTTP-Headers' metadata.
  job->addMetaData("PropagateHttpHeader", "true");
}

void KitaThreadView::slotRedirection(KIO::Job *, const KURL & newURL)
{
  printf("  Redirected to newURL: %s\n", newURL.url().latin1() );
  m_thread = Kita2ch::Thread(newURL);
  emit setLocationBarURL(newURL.url());
}

void KitaThreadView::slotReceiveThreadData(KIO::Job*, const QByteArray& data)
{
  QCString cstr(data.data(), data.size()+1);
  m_threadData.append(cstr);
}

int KitaThreadView::getServerTimeFromHttpHeaders(QString headers)
{
  // parse HTTP headers
  QStringList headerList = QStringList::split("\n", headers);
  QRegExp regexp("Date: (...), (..) (...) (....) (..:..:..) .*");
  QString dateStr = headerList.grep(regexp)[0];
  if(regexp.search(dateStr) == -1) {
    // invalid date format
    return time(NULL);
  } else {
    // I hate this format ;p
    QString usLocalDateStr = regexp.cap(1) + " " + regexp.cap(3) + " " +
                             regexp.cap(2) + " " + regexp.cap(5) + " " + regexp.cap(4);

    // 1970/01/01 00:00:00 GMT
    QDateTime zeroTime(QDate(1970, 1, 1), QTime(0, 0));
    return zeroTime.secsTo(QDateTime::fromString(usLocalDateStr));
  }
}

void KitaThreadView::slotThreadResult(KIO::Job* job)
{
  m_currentJob = 0;
  if(job->error()) {
    job->showErrorDialog();
    return;
  }

  QCp932Codec codec;
  QTextStream stream(m_threadData, IO_ReadOnly);
  stream.setCodec(&codec);
  QString line;
  QString text;
  int num = 0;

  m_serverTime = getServerTimeFromHttpHeaders(job->queryMetaData("HTTP-Headers"));

  int total = m_threadData.length();
  int step = 0;
  int divide = total / ( 100 / 5 );
  int next = divide;
  QProgressDialog * progress = new QProgressDialog( m_parent );
  progress->setTotalSteps( static_cast<int>(total * 0.7) );
  progress->setLabelText( "Parse DAT file.....");
  progress->show();
  
  text += "<html><head>";
  text += "</head><body>";
  while(!stream.atEnd()) {
    
    line = stream.readLine();
    Kita2ch::Comment comment(line);
    if( comment.isValid() == false) {
      continue;
    }

    num++;
    if(num == 1) {
      m_thread.setName(comment.getSubject());
    }
    text += comment.toHtml(num);

    if( (step+=line.length()) > next ) {
      progress->setProgress( step );
      next += divide;
    }
  }
  delete progress;
  
  m_thread.setResNum(num);
  emit setVestedNum(m_thread.datURL(), m_thread.resNum());

  QString disp( m_thread.name() );
  if ( ! m_board.name().isEmpty() ) { disp.prepend( QString("[%1]").arg(m_board.name()) ); }
  disp.truncate( m_labelMaxLength );
  subjectLabel->setText( disp );
  
  {
    int target;
    for ( target = 1; target < m_thread.resNum(); target += 100 )
      text += QString(" <a href=\"#%1\">%3</a> ").arg(target).arg(target);
    text += "<br/>";
  }
#if 0
  text += QString("<a href=\"%1#%2\">check new one.</a>").arg( m_datURL.url() ).arg( m_rescount );
#endif
  text += "</body></html>";
  m_contents = text;

  slotDisplayContents( m_contents, m_thread.datURL() );
  if ( HighLightButton->isOn() ) {
    HighLightButton->toggle();
  }
  m_threadData.truncate(0);

  if ( m_thread.datURL().hasRef() ) {
    if ( ! gotoAnchor( m_thread.datURL().encodedHtmlRef()) )
      gotoAnchor( m_thread.datURL().htmlRef() );
  } else {
    gotoAnchor( QString().setNum(m_thread.resNum() - 1) );
  }
  m_pointStack.clear();
  KHTMLView * view = m_threadPart->view();
  m_pointStack.push( QPoint( view->contentsX(), view->contentsY() ) );

  emit showThreadCompleted();
}

void KitaThreadView::slotDisplayContents(const QString& input, const KURL& url)
{
  printf("    begin Display: %s\n", url.url().latin1() );
  m_threadPart->begin( url );
  m_threadPart->write( input );
  m_threadPart->end();
  if ( ! url.isEmpty() ) emit setLocationBarURL(url.url());
}

void KitaThreadView::slotWriteButtonClicked()
{
  KitaWriteDialog dialog;

  QSjisCodec cp932Codec;
  KURL bbscgiURL = KURL(m_board.url(), "../test/bbs.cgi");
  bbscgiURL.setProtocol( "http" );

  KitaWriteDialog::PostInfo info;
  info.host = bbscgiURL.host();
  info.bbs = m_board.id();
  info.key = m_thread.datID();
  info.time = QString("%1").arg(m_serverTime);
  QDialog * new_dialog = KitaWriteDialog::open( info );
  connect( new_dialog, SIGNAL( postResponse(const QString&, const KURL&) ),
      	   this, SLOT( slotDisplayContents(const QString&, const KURL&) ) );
  new_dialog->show(); //work asynchronus.
}

void KitaThreadView::slotReceiveWriteResult(KIO::Job *,  const QByteArray & data)
{
  QCString cstr(data.data(), data.size()+1);
  m_writeResult += cstr;
}

void KitaThreadView::slotWriteResult(KIO::Job* job)
{
  if(job->error()) {
    job->showErrorDialog();
  } else {
    QSjisCodec codec;
    QTextStream stream(m_writeResult, IO_ReadOnly);
    stream.setCodec(&codec);

    m_threadPart->begin();
    m_threadPart->write( m_writeResult.data(), m_writeResult.size() );
    m_threadPart->end();
    qDebug("#%s#", (const char *)stream.read().local8Bit());
    m_writeResult.truncate(0);
  }
}

void KitaThreadView::slotCanceled(KIO::Job*)
{
}

void KitaThreadView::slotSearchButton()
{
  insertSearchCombo();
  QStringList list = parseSearchQuery( SearchCombo->currentText() );
  searchNext( list );
}

void KitaThreadView::slotHighLightenButton(bool yes)
{
  insertSearchCombo();
  QStringList list = parseSearchQuery( SearchCombo->currentText() );
  highLighten( yes, list );
}

void KitaThreadView::insertSearchCombo()
{
  int count;
  bool found = false;

  for( count = 0; count < SearchCombo->count(); ++count ) {
    if ( SearchCombo->text( count ) ==  SearchCombo->currentText() ) {
      found = true;
      break;
    }
  }
  if ( ! found ) SearchCombo->insertItem( SearchCombo->currentText() );
}

QStringList KitaThreadView::parseSearchQuery(const QString &input)
{
  QStringList tmp = QStringList::split( ' ', input );
  QStringList ret_list;
  QRegExp truncSpace("\\s*$");
  QStringList::iterator it = tmp.begin();
  for( ; it != tmp.end(); ++it )
    ret_list += (*it).replace( truncSpace, "" );
  return ret_list;
}

void KitaThreadView::searchNext(const QStringList &query)
{
  if ( query.isEmpty() ) return;
  if ( ! HighLightButton->isOn() ) {
    HighLightButton->toggle();
    m_nextHit = 0; //A next jump-search target reset to '0'.
    // Process works asynchronusly. So Firstly, we don't do jump-search as a simple solution.
    return;
  }
  if ( query != m_prevquery ) {
    highLighten( true, query );
    m_nextHit = 0; //A next jump-search target reset to '0'.
    return;
  }
    
  gotoAnchor( QString("highlighten%1").arg(m_nextHit)  );
  ++m_nextHit;
  if ( !( m_nextHit < m_hitcount ) ) m_nextHit = 0;
}

void KitaThreadView::highLighten(bool yes, const QStringList &query)
{
  if ( ! yes ) {
    m_threadPart->setUserStyleSheet( QString("") );
    return;
  }

  // Use style sheet to highlighten.
  QString highlightCSS( ".highlight { color: %1; background: %2; } ");
#if 0
  QColorGroup cg = m_threadPart->view()->colorGroup();
  highlightCSS = highlightCSS.arg( cg.highlightedText().name() ).arg( cg.highlight().name()  );
#else
  highlightCSS = highlightCSS.arg( "yellow" ).arg( "black" );
#endif
  m_threadPart->setUserStyleSheet( highlightCSS );
  

  if ( m_prevquery == query ) return;
  m_prevquery = query;
  if ( query.isEmpty() ) return;

  slotDisplayContents( m_contents, m_thread.datURL() );
  DOM::NodeList nodes;
  m_hitcount = 0;
  nodes = m_threadPart->document().getElementsByTagName("body");
  highLightenNodes( nodes, query );
  m_threadPart->setUserStyleSheet( highlightCSS );
}

QStringList KitaThreadView::lt_gt_spliter( const QString & input )
{
  QStringList lt_gt_splitted;
  QRegExp lt_gt("[<>]");
  int start = 0;
  int end = 0;
  while ( (end = input.find(lt_gt, end+1)) != -1 ) {
    if ( input.at(end) == '<' ) {
      lt_gt_splitted += input.mid( start, end-start );
      start = end;
    } else
    if ( input.at(end) == '>' ) {
      lt_gt_splitted += input.mid( start, end+1-start );
      start = end + 1;
    } else QMessageBox::warning( 0, "", "KitaThreadView::lt_gt_spliter()\n !!Bug!! Not Match.\n Will you contact with authors?");
  }
  lt_gt_splitted += input.mid( start );
  return lt_gt_splitted;
}

void KitaThreadView::highLightenNodes(DOM::NodeList nodes, const QStringList &query)
{
  for ( unsigned int count = 0; count < nodes.length(); ++count ) {
    DOM::HTMLElement dd = nodes.item(count);
    //printf(" dd %d: %s\n", count, dd.innerHTML().string().latin1() );
    QStringList lt_gt_split = lt_gt_spliter( dd.innerHTML().string() );

    QProgressDialog progress(m_parent);
    progress.setLabelText("Searching...");
    progress.setTotalSteps( lt_gt_split.size() );
    progress.show();
    int step = 0;
    int divide = lt_gt_split.size() / ( 100 / 5 );
    int next = divide;

    //loop order not optimized. Need optim. that also needs any codes & members?
    QStringList::iterator it_msg = lt_gt_split.begin();
    for( ; it_msg != lt_gt_split.end(); ++it_msg ) 
    {
      QStringList::const_iterator it = query.begin(); 
      for( ; it != query.end(); ++it )
      {
	int pos = 0;
	QString message = *it_msg;
	//printf("dd %d: %s\n", count, (*it_msg).latin1() );
	if( message.at(0) == '<' ) continue;
	while ( (pos = (*it_msg).find(*it, pos)) != -1 ) {
	  //QMessageBox::information( 0, "Hit!",  QString( "pos: %1 (length: %2)\nhitcount: %4\nstring:\n%3").arg(pos).arg((*it).length()).arg(message).arg(m_hitcount) );
	  QString replace = QString("<font class=\"highlight\" id=\"highlighten%2\">").arg( m_hitcount );
	  replace += *it;
	  replace += "</font>";
	  message.replace(pos, (*it).length(), replace);
	  //printf("dd %d: replaced:: %s\n", count, message.latin1() );
	  pos += replace.length();
	  lt_gt_split.insert( it_msg, message );
	  it_msg = lt_gt_split.remove( it_msg );
	  --it_msg;
	  ++m_hitcount;
	}
      }
      if( ++step > next ) {
	progress.setProgress( step );
	next += divide;
      }
    }

    dd.setInnerHTML( lt_gt_split.join(" ") );

  }
}

void KitaThreadView::slotOnURL(const QString& url)
{
  emit signalChangeStatusbar(url);
}

bool KitaThreadView::gotoAnchor( const QString &name )
{
  KHTMLView * view = m_threadPart->view();
  m_pointStack.push( QPoint( view->contentsX(), view->contentsY() ) );
  return m_threadPart->gotoAnchor( name );
}

bool KitaThreadView::gobackAnchor()
{
  QPoint p = m_pointStack.pop();
  if ( m_pointStack.isEmpty() ) m_pointStack.push( p );
  m_threadPart->view()->setContentsPos( p.x(), p.y()  );
  return true;
}

void KitaThreadView::slotPopupMenu( KXMLGUIClient *client, const QPoint &global, const KURL &url, const QString &mimeType, mode_t mode)
{
  KActionCollection * collection = client->actionCollection();
  KAction * action;
  action = new KAction( i18n("goback anchor"), SmallIcon("idea"), KShortcut(), this, SLOT( gobackAnchor() ), collection, "goback_anchor" );
  printf("  KitaThreadView::slotPopupMenu() %p\n", action);
  emit popupMenu(client, global, url, mimeType, mode);
}

void KitaThreadView::slotOpenURLRequest(const KURL& url, const KParts::URLArgs& args)
{
  printf(" openURLRequest:: orgURL %s\n", url.url().latin1() );
  if ( url.url().at(0) == '#' ) {
    gotoAnchor( url.ref() );
    return;
  }
  KURL datURL = filterReadCGI( url );
  if ( datURL.host() == m_thread.datURL().host()
    && datURL.path() == m_thread.datURL().path() )
  {
    if ( datURL.hasRef() ) gotoAnchor( datURL.ref() );
    return;
  }
  emit openURLRequest(datURL, args);
}

void KitaThreadView::slotReloadButton()
{
  slotShowThread(m_board, m_thread);
}
    
KURL KitaThreadView::filterReadCGI(const KURL& url)
{
  KURL  newURL = url;
  if ( url.path().contains("/test/read.cgi") ) {
    newURL.setProtocol( m_thread.datURL().protocol() );
    QString tmp = url.path().section("/test/read.cgi", 1);
    //printf("    tmp: %s\n", tmp.latin1() );

    QString newPath = QString( "/%1/dat/%2.dat" )
               .arg( tmp.section('/', 1, 1) )
	       .arg( tmp.section('/', 2, 2) );
    newURL.setPath( newPath );
    //printf("    newPath: %s\n", newPath.latin1() );

    QString refBase = tmp.section('/', 3);
    if ( ! refBase.isEmpty() ) {
      QString newRef =  refBase.section('-', 0, 0);
      if( ! newRef.isEmpty() ) newURL.setRef( newRef );
      else if ( refBase.at(0) == '-' ) newURL.setRef("1");
      else newURL.setRef( refBase );
    }
  }
  printf("    newURL: %s\n", newURL.url().latin1() );
  return newURL;
}

void KitaThreadView::slotFontChanged(QFont& font)
{
  m_threadPart->setStandardFont(font.family());
}
// vim:sw=2:
