//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Hideki Ikemoto <ikemo@wakaba.jp>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kitahtmlpart.h"

#include "kitathreadview.h"

#include <khtmlview.h>
#include <dom/html_element.h>

#include <qprogressdialog.h>
#include <qmessagebox.h>

KitaHTMLPart::KitaHTMLPart(QWidget *parent, const char *name)
 : KHTMLPart(parent, name), m_parent(parent)
{
}


KitaHTMLPart::~KitaHTMLPart()
{
}

void KitaHTMLPart::highLightenNodes(DOM::NodeList nodes, const QStringList &query)
{
  for ( unsigned int count = 0; count < nodes.length(); ++count ) {
    DOM::HTMLElement dd = nodes.item(count);
    //printf(" dd %d: %s\n", count, dd.innerHTML().string().latin1() );
    QStringList lt_gt_split = lt_gt_spliter( dd.innerHTML().string() );

    QProgressDialog progress(m_parent);
    progress.setLabelText("Searching...");
    progress.setTotalSteps( lt_gt_split.size() );
    progress.show();
    int step = 0;
    int divide = lt_gt_split.size() / ( 100 / 5 );
    int next = divide;

    //loop order not optimized. Need optim. that also needs any codes & members?
    QStringList::iterator it_msg = lt_gt_split.begin();
    for( ; it_msg != lt_gt_split.end(); ++it_msg )
    {
      QStringList::const_iterator it = query.begin();
      for( ; it != query.end(); ++it )
      {
	int pos = 1;
	QString message = *it_msg;
	//printf("dd %d: %s\n", count, (*it_msg).latin1() );
	if( message.at(0) == '<' ) continue;
	while ( (pos = (*it_msg).find(*it, pos)) != -1 ) {
	  QString replace = QString("<font class=\"highlight\" id=\"highlighten%2\">").arg( m_hitCount );
	  replace += *it;
	  replace += "</font>";
	  message.replace(pos, (*it).length(), replace);
	  //printf("dd %d: replaced:: %s\n", count, message.latin1() );
	  pos += replace.length();
	  lt_gt_split.insert( it_msg, message );
	  it_msg = lt_gt_split.remove( it_msg );
	  --it_msg;
	  ++m_hitCount;
	}
      }
      if( ++step > next ) {
	progress.setProgress( step );
	next += divide;
      }
    }

    dd.setInnerHTML( lt_gt_split.join(" ") );

  }
}

QStringList KitaHTMLPart::lt_gt_spliter( const QString & input )
{
  QStringList lt_gt_splitted;
  QRegExp lt_gt("[<>]");
  int start = 0;
  int end = 0;
  while ( (end = input.find(lt_gt, end+1)) != -1 ) {
    if ( input.at(end) == '<' ) {
      lt_gt_splitted += input.mid( start, end-start );
      start = end;
    } else
    if ( input.at(end) == '>' ) {
      lt_gt_splitted += input.mid( start, end+1-start );
      start = end + 1;
    } else QMessageBox::warning( 0, "", "KitaThreadView::lt_gt_spliter()\n !!Bug!! Not Match.\n Will you contact with authors?");
  }
  lt_gt_splitted += input.mid( start );
  return lt_gt_splitted;
}

void KitaHTMLPart::slotDisplayContents(const QString& input, const KURL& url)
{
  printf("    begin Display: %s\n", url.url().latin1() );
  begin( url );
  write( input );
  end();
  if ( ! url.isEmpty() ) emit setLocationBarURL(url.url());
}

void KitaHTMLPart::pushCurrentPosition()
{
  m_pointStack.push( QPoint( view()->contentsX(), view()->contentsY() ) );
}

bool KitaHTMLPart::gobackAnchor()
{
  QPoint p = m_pointStack.pop();
  if ( m_pointStack.isEmpty() ) {
    m_pointStack.push( p );
  }
  view()->setContentsPos( p.x(), p.y() );

  return true;
}

bool KitaHTMLPart::gotoAnchor(const QString& name)
{
  pushCurrentPosition();
  return KHTMLPart::gotoAnchor( name );
}

int KitaHTMLPart::nextHit()
{
  m_nextHit++;
  if ( m_nextHit >= m_hitCount ) m_nextHit = 0;

  return m_nextHit;
}
