//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Hideki Ikemoto <ikemo@wakaba.jp>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KITAHTMLPART_H
#define KITAHTMLPART_H

#include <khtml_part.h>

#include <qstringlist.h>

#include <qvaluestack.h> // for gcc-2.9x
template<class T> class QValueStack;

/**
@author Hideki Ikemoto
*/
class KitaHTMLPart : public KHTMLPart
{
  Q_OBJECT

  QWidget* m_parent;
  int m_hitCount;
  QStringList m_prevQuery;
  QString m_contents;
  int m_nextHit;
  QValueStack<QPoint> m_pointStack;
public:
  int nextHit();
  void resetHit() { m_nextHit = 0; }
  void resetHitCount() { m_hitCount = 0; }
  QStringList prevQuery() { return m_prevQuery; }
  QString contents() { return m_contents; }
  void pushCurrentPosition();
  void clearPosition() { m_pointStack.clear(); }
  bool gobackAnchor();
  bool gotoAnchor(const QString& name);

  void setPrevQuery(QStringList prevQuery) { m_prevQuery = prevQuery; }
  void setContents(QString contents) { m_contents = contents; }

  KitaHTMLPart(QWidget *parent, const char *name = 0);
  ~KitaHTMLPart();
  void highLightenNodes(DOM::NodeList nodes, const QStringList &query);
  static QStringList lt_gt_spliter( const QString & input );
  void slotDisplayContents(const QString& input, const KURL& urlOfInput = 0);
signals:
  void setLocationBarURL( const QString &url );
};

#endif
