/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITAWRITEDIALOG_H_
#define _KITAWRITEDIALOG_H_

#include <qwidget.h>
#include <kio/job.h>
#include "kitawritedialogbase.h"
#include "kita2ch.h"

template<class type> class QPtrList;
class KitaWriteDialogPrivate;
class KitaWriteDialog;

/**
 * 
 * Hideki Ikemoto
 **/
class KitaWriteDialog : public KitaWriteDialogBase
{
  Q_OBJECT
public:
  KitaWriteDialog(QWidget *parent=0, const char *name=0 );
  virtual ~KitaWriteDialog();
  QString name();
  QString mail();
  QString body();

  virtual bool error(){ return false; };

  static KitaWriteDialog * open( const Kita2ch::PostInfo& info );

public slots:
  void postMessage();

signals:
  void postStarted( KIO::Job *, const Kita2ch::PostInfo& );
  void postFinished( KIO::Job * );
  void postResponse( const QString& response, const KURL& bbscgi = KURL() );

protected:
  Kita2ch::PostInfo m_postInfo;

private:
  void fetchPostInfo( Kita2ch::PostInfo * storage );

  QCString m_array;
  bool m_error;
  static KitaWriteDialogPrivate * s_private;

private slots:
  void slotRecieveData(KIO::Job *, const QByteArray &);
  void slotPostFinished(KIO::Job *);

};

class KitaWriteDialogPrivate
{
public:
   QPtrList<KitaWriteDialog> m_heaplist;
};
#endif
