/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITA_H_
#define _KITA_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kdockwidget.h>

#include "kitaconfig.h"

#include "libkita/thread.h"

class KPrinter;
class KToggleAction;
class KURL;
class KitaThreadTabWidget;
class KitaBoardView;
class KitaSubjectTabWidget;
class KLineEdit;

namespace KParts{
  class URLArgs;
};

/**
 * This class serves as the main window for Kita.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */

class KitaMainWindow : public KDockMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    KitaMainWindow();

    /**
     * Default Destructor
     */
    virtual ~KitaMainWindow();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const KURL& url);

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);

    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);

    void readConfig(KConfig *);
    void writeConfig(KConfig *);

private slots:
    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
    void windowShowBoardlist();
    void windowShowSubjectlist();
    void windowMenuAboutToShow();
    void slotEditCopy();

    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);
    void slotOpenURLRequest(const KURL& url, const KParts::URLArgs&);
    void updateThreadCache( const Kita::Thread& thread );
    void setFont( const QFont& font );
    void slotWriteSucceeded();
    void slotUrlLine();
    void setUrl(const KURL& url);
    void bookmark( const Kita::Thread& thread, bool on );
    void slotThread( const Kita::Thread& thread );

private:
    KitaThreadTabWidget* m_threadView;
    KitaBoardView* m_boardView;
    KitaSubjectTabWidget* m_subjectView;
    KLineEdit* m_urlLine;

    KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KToggleAction *m_boardListAction;
    KToggleAction* m_subjectListAction;

    KDockWidget* m_boardDock;
    KDockWidget* m_subjectDock;

    void setupAccel();
    void setupActions();
    void setupView();
    void loadCache();
    void saveCache();
    void loadFavorites();
    void saveFavorites();
};

#endif // _KITA_H_
