/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KITACOMMENT_H
#define KITACOMMENT_H

#include <qstring.h>
#include <qdatetime.h>

namespace Kita
{
  class Comment
  {
    QString m_name;
    QString m_address;
    QDateTime m_dateTime;
    QString m_id;

    QString m_body;
    QString m_subject;
    bool m_isValid;
    QString m_dateId;
  public:
    Comment();
    Comment(const QString& line);
    ~Comment() {}
    const QString& getName() const;
    const QString& getAddress() const;
    QString getDateId() const;
    const QString& getBody() const;
    const QString& getSubject() const;
    bool isValid() const { return m_isValid; }
    QString toHtml(int num) const;
  private:
    void parseDateId(const QString& str);
    QString linkedAddress() const;
    QString linkedBody() const;
  };
};

#endif /* ! KITACOMMENT_H */
