/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitahtmlpart.h"

#include "kitathreadview.h"
#include "kitahtmlview.h"

#include <kpopupmenu.h>
#include <klocale.h>
#include <khtmlview.h>
#include <dom/html_element.h>

#include <qprogressdialog.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qclipboard.h>

#include "libkita/thread.h"

enum {
  ID_Copy_Link
};

KitaHTMLPart::KitaHTMLPart( QWidget *parent, const char *name )
 : KHTMLPart( new KitaHTMLView( this, parent, name ) )
 , m_parent(parent)
{
  connect( this, SIGNAL( popupMenu( const QString&, const QPoint& ) ),
           SLOT( slotPopupMenu( const QString&, const QPoint& ) ) );

  m_popupMenu = new KPopupMenu( view() );
}


KitaHTMLPart::~KitaHTMLPart()
{
}

void KitaHTMLPart::reset()
{
  m_prevQuery = "";
  m_nextHit = -1;
  m_hitCount = 0;
  m_contents = "";
  m_pointStack.clear();
}

void KitaHTMLPart::highLightenNodes( DOM::NodeList nodes, const QStringList &query )
{
  for ( unsigned int count = 0; count < nodes.length(); ++count ) {
    DOM::HTMLElement dd = nodes.item(count);
    QStringList lt_gt_split = lt_gt_spliter( dd.innerHTML().string() );

    QProgressDialog progress(m_parent);
    progress.setLabelText("Searching...");
    progress.setTotalSteps( lt_gt_split.size() );
    progress.show();
    int step = 0;
    int divide = lt_gt_split.size() / ( 100 / 5 );
    int next = divide;

    //loop order not optimized. Need optim. that also needs any codes & members?
    QStringList::iterator it_msg = lt_gt_split.begin();
    for( ; it_msg != lt_gt_split.end(); ++it_msg )
    {
      QStringList::const_iterator it = query.begin();
      for( ; it != query.end(); ++it )
      {
	int pos = 1;
	QString message = *it_msg;
	if( message.at(0) == '<' ) continue;
	while ( (pos = (*it_msg).find(*it, pos)) != -1 ) {
	  QString replace = QString("<font class=\"highlight\" id=\"highlighten%2\">").arg( m_hitCount );
	  replace += *it;
	  replace += "</font>";
	  message.replace(pos, (*it).length(), replace);
	  pos += replace.length();
	  lt_gt_split.insert( it_msg, message );
	  it_msg = lt_gt_split.remove( it_msg );
	  --it_msg;
	  ++m_hitCount;
	}
      }
      if( ++step > next ) {
	progress.setProgress( step );
	next += divide;
      }
    }

    dd.setInnerHTML( lt_gt_split.join(" ") );

  }
}

QStringList KitaHTMLPart::lt_gt_spliter( const QString & input )
{
  QStringList lt_gt_splitted;
  QRegExp lt_gt("[<>]");
  int start = 0;
  int end = 0;
  while ( (end = input.find(lt_gt, end+1)) != -1 ) {
    if ( input.at(end) == '<' ) {
      lt_gt_splitted += input.mid( start, end-start );
      start = end;
    } else
    if ( input.at(end) == '>' ) {
      lt_gt_splitted += input.mid( start, end+1-start );
      start = end + 1;
    } else QMessageBox::warning( 0, "", "KitaThreadView::lt_gt_spliter()\n !!Bug!! Not Match.\n Will you contact with authors?");
  }
  lt_gt_splitted += input.mid( start );
  return lt_gt_splitted;
}

void KitaHTMLPart::displayContents( const QString& input, const KURL& url )
{
  m_url = url;

  begin( url );
  write( input );
  end();
  if ( ! url.isEmpty() ) emit setLocationBarURL(url.url());
}

void KitaHTMLPart::displayContentsAndGotoURL( const QString& input, const Kita::Thread& thread )
{
  m_contents = input;
  displayContents( contents(), thread.datURL() );

  if ( thread.datURL().hasRef() ) {
    if ( ! gotoAnchor( thread.datURL().encodedHtmlRef()) )
      gotoAnchor( thread.datURL().htmlRef() );
  } else {
    gotoAnchor( QString().setNum( thread.resNum() ) );
  }
  clearPosition();
  pushCurrentPosition();
}

void KitaHTMLPart::pushCurrentPosition()
{
  m_pointStack.push( QPoint( view()->contentsX(), view()->contentsY() ) );
}

bool KitaHTMLPart::gobackAnchor()
{
  QPoint p = m_pointStack.pop();
  if ( m_pointStack.isEmpty() ) {
    m_pointStack.push( p );
  }
  view()->setContentsPos( p.x(), p.y() );

  return true;
}

bool KitaHTMLPart::gotoAnchor( const QString& name )
{
  pushCurrentPosition();
  return KHTMLPart::gotoAnchor( name );
}

int KitaHTMLPart::nextHit()
{
  m_nextHit++;
  if ( m_nextHit >= m_hitCount ) m_nextHit = 0;

  return m_nextHit;
}

void KitaHTMLPart::slotPopupMenu( const QString& url, const QPoint& point )
{
  m_popupMenu->clear();
  m_popupMenu->insertItem( i18n("Copy Link Location"), ID_Copy_Link );

  QClipboard* clipboard = QApplication::clipboard();

  switch( m_popupMenu->exec( point ) ) {
  case ID_Copy_Link:
    clipboard->setText( url );
    break;
  default:
    break;
  }
}

void KitaHTMLPart::highLighten( bool yes, const QStringList &query )
{
  if ( ! yes ) {
    setUserStyleSheet( QString("") );
    return;
  }

  // Use style sheet to highlighten.
  QString highlightCSS( ".highlight { color: %1; background: %2; } ");
  highlightCSS = highlightCSS.arg( "yellow" ).arg( "black" );

  if ( prevQuery() != query && !query.isEmpty() ) {
    m_prevQuery = query;
    displayContents( contents(), m_url );
    DOM::NodeList nodes;
    resetHit();
    m_hitCount = 0;
    nodes = document().getElementsByTagName("body");
    highLightenNodes( nodes, query );
  }
  setUserStyleSheet( highlightCSS );
}
