/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitacacheinfo.h"

#include <kurl.h>

#include <qmap.h>
#include <qdatastream.h>

KitaCacheInfo* KitaCacheInfo::instance = 0;

KitaCacheInfo::KitaCacheInfo() : m_readDict()
{
}

KitaCacheInfo::~KitaCacheInfo()
{
}

KitaCacheInfo* KitaCacheInfo::getInstance()
{
  if( instance == 0 ) {
    instance = new KitaCacheInfo();
  }
  return instance;
}

int KitaCacheInfo::readNum(const KURL& url)
{
  QString key = url.url();
  if( m_readDict.contains(key) ) {
    return m_readDict[key];
  } else {
    return 0;
  }
}

void KitaCacheInfo::setReadNum(const KURL& url, int num)
{
  m_readDict.insert(url.url(), num);
}

int KitaCacheInfo::resNum( const KURL& url )
{
  QString key = url.url();
  if( m_resNumDict.contains( key ) ) {
    return m_resNumDict[ key ];
  } else {
    return 0;
  }
}

void KitaCacheInfo::setResNum( const KURL& url, int num )
{
  m_resNumDict.insert( url.url(), num );
}

QDataStream& operator<<(QDataStream& s, KitaCacheInfo& c)
{
  s << c.m_readDict;
  return s;
}

QDataStream& operator>>(QDataStream& s, KitaCacheInfo& c)
{
  s >> c.m_readDict;
  return s;
}
