/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "kita_misc.h"

#include <kurl.h>
#include <qregexp.h>

namespace Kita {

KURL datToThread( const KURL& datURL )
{
  QRegExp regexp( "http://([^/]*)/([^/]*)/dat/(.*)\\.dat" );
  if( regexp.search( datURL.url() ) == -1 ) {
    // no match
    return KURL( "" );
  }
  QString url= QString( "http://%1/test/read.cgi/%2/%3/" )
                        .arg( regexp.cap(1) )
                        .arg( regexp.cap(2) )
                        .arg( regexp.cap(3) );
  return KURL( url );
}

KURL threadToDat( const KURL& threadURL )
{
  QRegExp regexp( "http://([^/]*)/test/read\\.cgi/([^/]*)/([^/]*)/?" );
  if( regexp.search( threadURL.url() ) == -1 ) {
    // no match
    return KURL( "" );
  }
  QString url = QString( "http://%1/%2/dat/%3.dat" )
                         .arg( regexp.cap(1) )
                         .arg( regexp.cap(2) )
                         .arg( regexp.cap(3) );
  return KURL( url );
}

KURL boardToSubject( const KURL& boardURL )
{
  KURL url( boardURL );
  url.addPath( "subject.txt" );
  return url;
}

KURL subjectToBoard( const KURL& subjectURL )
{
  return KURL( subjectURL, "." );
}

QString datToCache( const KURL& datURL )
{
  QRegExp regexp( "http://([^/]*)/([^/]*)/dat/(.*)" );
  if( regexp.search( datURL.url() ) == -1 ) {
    return "";
  }
  return QString( "%1/%2/%3" ).arg( regexp.cap(1) )
                              .arg( regexp.cap(2) )
                              .arg( regexp.cap(3) );
}

};
