/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "urlconverttest.h"

#include <kurl.h>

void URLConvertTest::setUp()
{
  m_datURL = KURL( "http://pc.2ch.net/linux/dat/1022744633.dat" );
  m_threadURL = KURL( "http://pc.2ch.net/test/read.cgi/linux/1022744633/" );
  m_threadURL2 = KURL( "http://pc.2ch.net/test/read.cgi/linux/1022744633" );
  m_subjectURL = KURL( "http://pc.2ch.net/linux/subject.txt" );
  m_boardURL = KURL( "http://pc.2ch.net/linux/" );
  m_boardURL2 = KURL( "http://pc.2ch.net/linux" );

  // relative path.
  m_cachePath = QString( "pc.2ch.net/linux/1022744633.dat" );
}

void URLConvertTest::tearDown()
{
}

void URLConvertTest::testDatToThread()
{
  CPPUNIT_ASSERT_EQUAL( m_threadURL.url(), Kita::datToThread( m_datURL ).url() );
}

void URLConvertTest::testThreadToDat()
{
  CPPUNIT_ASSERT_EQUAL( m_datURL.url(), Kita::threadToDat( m_threadURL ).url() );
  CPPUNIT_ASSERT_EQUAL( m_datURL.url(), Kita::threadToDat( m_threadURL2 ).url() );
}

void URLConvertTest::testBoardToSubject()
{
  CPPUNIT_ASSERT_EQUAL( m_subjectURL.url(), Kita::boardToSubject( m_boardURL ).url() );
  CPPUNIT_ASSERT_EQUAL( m_subjectURL.url(), Kita::boardToSubject( m_boardURL2 ).url() );
}

void URLConvertTest::testSubjectToBoard()
{
  CPPUNIT_ASSERT_EQUAL( m_boardURL.url(), Kita::subjectToBoard( m_subjectURL ).url() );
}

void URLConvertTest::testDatToCache()
{
  CPPUNIT_ASSERT_EQUAL( m_cachePath, Kita::datToCache( m_datURL ) );
}
