/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef URLCONVERTTEST_H
#define URLCONVERTTEST_H

#include <cppunit/extensions/HelperMacros.h>
#include "../kita_misc.h"

#include <kurl.h>

/**
@author Hideki Ikemoto
*/
class URLConvertTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( URLConvertTest );
  CPPUNIT_TEST( testDatToThread );
  CPPUNIT_TEST( testThreadToDat );
  CPPUNIT_TEST( testBoardToSubject );
  CPPUNIT_TEST( testSubjectToBoard );
  CPPUNIT_TEST( testDatToCache );
  CPPUNIT_TEST_SUITE_END();

  KURL m_datURL;
  KURL m_threadURL;
  KURL m_threadURL2;
  KURL m_subjectURL;
  KURL m_boardURL;
  KURL m_boardURL2;
  QString m_cachePath;

public:
  void setUp();
  void tearDown();

  void testDatToThread();
  void testThreadToDat();
  void testBoardToSubject();
  void testSubjectToBoard();
  void testDatToCache();
};

#endif
