/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kita2ch.h"

#include <kurl.h>
#include <kfilterdev.h>
#include <klocale.h>
#include <kdebug.h>

#include <kio/slaveconfig.h>
#include <kio/netaccess.h>

#include <qtextcodec.h>
#include <qregexp.h>
#include <qdatetime.h>

#include "libkita/qcp932codec.h"
#include "libkita/thread.h"

using namespace Kita;

WriteResult::WriteResult(QString str) : m_str(str)
{
}

K2chResultCode WriteResult::code() const
{
  QRegExp regexp("<!-- 2ch_X:(.*) -->");
  int pos = regexp.search(m_str);

  QString k2ch_X;
  if(pos != -1) {
    k2ch_X = regexp.cap(1);
  } else {
    return K2ch_Unknown;
  }

  if(k2ch_X == "true") {
    return K2ch_True;
  } else if(k2ch_X == "false") {
    return K2ch_False;
  } else if(k2ch_X == "error") {
    return K2ch_Error;
  } else if(k2ch_X == "check") {
    return K2ch_Check;
  } else if(k2ch_X == "cookie") {
    return K2ch_Cookie;
  } else {
    kdWarning() << "unknown 2ch_X: " << k2ch_X << endl;
    return K2ch_Unknown;
  }
}

QString WriteResult::message() const
{
  QRegExp regexp("<b>([^<]*)</b>");
  int pos = regexp.search(m_str);
  if(pos != -1) {
    return regexp.cap(1);
  } else {
    return QString::null;
  }
}

QString WriteResult::title() const
{
  QRegExp regexp("<title>(.*)</title>");
  int pos = regexp.search(m_str);
  if(pos != -1) {
    return regexp.cap(1);
  } else {
    return QString::null;
  }
}

bool PostInfo::check() const
{
  if ( host.isEmpty() || bbscgi.isEmpty()
     || bbs.isEmpty() || key.isEmpty() )
	return false;

  return true;
}

QString PostInfo::postStr()
{
  QCp932Codec codec;
  int mib = codec.mibEnum();
  QString ret;
  (ret += "submit=") += submit;
  (ret += "&subject=");
  (ret += "&FROM=") += KURL::encode_string(name, mib);
  (ret += "&mail=") += KURL::encode_string(mail, mib);
  (ret += "&MESSAGE=") += KURL::encode_string(body, mib);
  (ret += "&bbs=") += bbs;
  (ret += "&key=") += key;
  (ret += "&time=") += time;

  return ret;
}
