/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitahtmlview.h"

#include <khtml_part.h>

#include <qapplication.h>
#include <qclipboard.h>

KitaHTMLView::KitaHTMLView( KHTMLPart* part, QWidget *parent, const char *name )
 : KHTMLView( part, parent, name )
{
}

KitaHTMLView::~KitaHTMLView()
{
}

void KitaHTMLView::leaveEvent( QEvent* )
{
  emit leave();
}

void KitaHTMLView::keyPressEvent( QKeyEvent* e )
{
  QClipboard* clipboard = QApplication::clipboard();

  if( e->state() == ControlButton && e->key() == Key_C ) {
    QString text = part()->selectedText();
    clipboard->setText( text );
  } else {
    KHTMLView::keyPressEvent( e );
  }
}
