/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITASUBJECTVIEW_H_
#define _KITASUBJECTVIEW_H_

#include <qwidget.h>
#include <kurl.h>
#include "kitasubjectviewbase.h"
#include "part/kita2ch.h"
#include "libkita/board.h"

class KListViewItem;

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/
class KitaSubjectView : public KitaSubjectViewBase
{
  Q_OBJECT

public:
  KitaSubjectView( QWidget *parent, const char *name=0 );
  ~KitaSubjectView();

public slots:
  void reloadSubject();
  void loadBoard( const Kita::Board* board );
  void setFont( const QFont& font );
  void updateThread( const Kita::Thread& thread );

private:
  const Kita::Board* m_board;
  QStringList m_prevquery;
  unsigned m_nextHitIndex;
  QValueList<KListViewItem*> m_hitList;

  void insertSearchCombo();
  QStringList parseSearchQuery(const QString &input);
  void searchNext(const QStringList &input);
  void searchAll(const QStringList &query);

private slots:
  void loadThread( int, QListViewItem* item );
  void slotSearchButton();
  void slotHideButton(bool on);
  void slotContextMenuRequested( QListViewItem*, const QPoint&, int );

signals:
  void loadBoardCompleted(const KURL&);
  void signalShowThread( const Kita::Thread& thread );
  void signalShowThreadWithNewTab( const Kita::Thread& thread );
};

#endif
