/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITATHREADINFO_H_
#define _KITATHREADINFO_H_

#include <kurl.h>

#include <qmap.h>

/**
 * 
 * Hideki Ikemoto
 **/

class KitaThreadInfo
{
public:
  static KitaThreadInfo* getInstance();
  static void setReadNum( const QString& url, int num );
  static int readNum( const QString& url );
  static void setResNum( const QString& url, int num );
  static int resNum( const QString& url );
  friend QDataStream& operator<<( QDataStream& s, KitaThreadInfo& c );
  friend QDataStream& operator>>( QDataStream& s, KitaThreadInfo& c );
private:
  KitaThreadInfo();
  ~KitaThreadInfo();
  QMap<QString, int> m_readDict;
  QMap<QString, int> m_resNumDict;
  static KitaThreadInfo* instance;
};

#endif
