/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "favoritelistview.h"

#include "libkita/favoritethreads.h"
#include "libkita/kita_misc.h"
#include "libkita/threadinfo.h"

#include <qmap.h>
#include <qapplication.h>
#include <qclipboard.h>

#include <klocale.h>
#include <kpopupmenu.h>
#include <krun.h>
#include <kdebug.h>
#include <klistview.h>

FavoriteListView::FavoriteListView( QWidget* parent, const char* name )
        : Kita::ThreadListView( parent, name )
{
    connect( subjectList, SIGNAL( clicked( QListViewItem* ) ),
             SLOT( loadThread( QListViewItem* ) ) );
    connect( subjectList, SIGNAL( contextMenuRequested( QListViewItem*, const QPoint&, int ) ),
             SLOT( slotContextMenuRequested( QListViewItem*, const QPoint&, int ) ) );
}

FavoriteListView::~FavoriteListView()
{}

void FavoriteListView::update()
{
    // FIXME: KitaSubjectView::loadBoard()˥ԡ
    {
        m_hitList.clear();
        m_nextHitIndex = 0;
        m_prevquery = "";
    }

    const QDict<Kita::Thread>& threads = FavoriteThreads::getInstance() ->threads();
    //  FavoriteThreads::const_iterator it;

    subjectList->clear();

    KitaThreadInfo* cache = KitaThreadInfo::getInstance();

    QDictIterator<Kita::Thread> it( threads );
    for ( ; it.current(); ++it ) {
        const Kita::Thread* thread = it.current();

        int readNum = cache->readNum( thread->datURL() );
        int resNum = cache->resNum( thread->datURL() );  // TODO unused variables.

        KListViewItem* item = new KListViewItem( subjectList );
        item->setText( Row_Board, thread->boardName() );
        item->setText( Row_Subject, thread->name() );
        item->setText( Row_Read, QString( "%1" ).arg( readNum, 4 ) );
        item->setText( Row_DatName, KURL( thread->datURL() ).fileName() );
        item->setText( Row_DatURL, thread->datURL() );
    }
}

void FavoriteListView::loadThread( QListViewItem* item )
{
    if ( ! item ) return ;

    const QDict<Kita::Thread>& threads = FavoriteThreads::getInstance() ->threads();
    //  FavoriteThreads::const_iterator it;

    QDictIterator<Kita::Thread> it( threads );
    for ( ; it.current(); ++it ) {
        const Kita::Thread* thread = it.current();

        if ( thread->datURL() == item->text( Row_DatURL ) ) {
            emit signalShowThread( thread );
        }
    }
}

void FavoriteListView::updateThread( const Kita::Thread* updated_thread )
{
    for ( QListViewItem * item = subjectList->firstChild(); item; item = item->nextSibling() ) {
        if ( item->text( Row_DatURL ) == updated_thread->datURL() ) {
            item->setText( Row_ResNum, QString( "%1" ).arg( updated_thread->resNum(), 4 ) );
        }
    }
}

// TODO: KitaSubjectView饹Ʊ᥽åɤȤۤȤƱ
void FavoriteListView::slotContextMenuRequested( QListViewItem* item, const QPoint& point, int )
{
    if ( item == 0 ) {
        return ;
    }

    KPopupMenu popup( 0 );
    popup.insertItem( i18n( "Open with Web Browser" ), 0 );
    popup.insertItem( i18n( "Open with new tab" ), 1 );
    popup.insertItem( i18n( "Copy title and URL" ), 2 );

    QString datName = item->text( Row_DatName );
    KURL datURL = KURL( item->text( Row_DatURL ) );

    Kita::Thread::setName( datURL.url(), item->text( Row_Subject ) );
    Kita::Thread* thread = Kita::Thread::getByURL( datURL.url() );
    KitaThreadInfo::setResNum( datURL.url(), item->text( Row_Read ).toInt() );

    QClipboard* clipboard = QApplication::clipboard();

    switch ( popup.exec( point ) ) {
    case 0:
        KRun::runURL( thread->url(), "text/html" );
        break;
    case 1:
        emit signalShowThreadWithNewTab( thread );
        break;
    case 2:
        clipboard->setText( thread->name() + "\n" + thread->url() );
        break;
    default:
        break;
    }
}
