/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITASUBJECTTABWIDGET_H
#define KITASUBJECTTABWIDGET_H

#include <qtabwidget.h>
#include <qtabbar.h>

#include "favoritelistview.h"
#include "kitasubjectview.h"

/**
@author Hideki Ikemoto
*/
class KitaSubjectTabWidget : public QTabWidget
{
    Q_OBJECT

public:
    KitaSubjectTabWidget( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaSubjectTabWidget();

public slots:
    void loadBoard( const Kita::Board*, bool withNewTab = false );
    void updateThread( const Kita::Thread* );

private:
    FavoriteListView* m_favoriteList;
    KitaSubjectView* m_latestView;
    void connectSignals( Kita::ThreadListView* );

private slots:
    void slotCurrentChanged( QWidget* widget );
    void deleteView( KitaSubjectView* view );

signals:
    void signalShowThread( const Kita::Thread* );
    void signalShowThreadWithNewTab( const Kita::Thread* );
    void loadBoardCompleted( const KURL& );
};

namespace Kita
{
    class SubjectTabBar : public QTabBar
    {
        Q_OBJECT

    public:
        SubjectTabBar( QWidget* parent = 0, const char* name = 0 );
        ~SubjectTabBar();

    protected:
        virtual void contextMenuEvent( QContextMenuEvent* e );

    signals:
        void deleteMenuSelected( KitaSubjectView* );
    };
};

#endif
