/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "kitasubjectview.h"

// include files for Qt
#include <qtoolbutton.h>
#include <qtextbrowser.h>
#include <qtextcodec.h>
#include <qregexp.h>
#include <qfile.h>
#include <qclipboard.h>
#include <qapplication.h>

// kdelibs/kio
#include <kio/slaveconfig.h>
#include <kio/netaccess.h>

// include files for KDE
#include <kfilterdev.h>
#include <klistview.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <krun.h>

#include "libkita/threadinfo.h"
#include "libkita/thread.h"
#include "libkita/kita_misc.h"
#include "part/kita2ch.h"

KitaSubjectView::KitaSubjectView( QWidget* parent, const char* name )
        : Kita::ThreadListView( parent, name )
        , m_board( 0 )
{
    connect( subjectList, SIGNAL( contextMenuRequested( QListViewItem*, const QPoint&, int ) ),
             SLOT( slotContextMenuRequested( QListViewItem*, const QPoint&, int ) ) );
    connect( subjectList, SIGNAL( clicked( QListViewItem* ) ),
             SLOT( loadThread( QListViewItem* ) ) );
    connect( subjectList, SIGNAL( returnPressed( QListViewItem* ) ),
             SLOT( loadThread( QListViewItem* ) ) );
}

KitaSubjectView::~KitaSubjectView()
{}

void KitaSubjectView::reloadSubject()
{}

const QString KitaSubjectView::boardURL()
{
    if ( m_board ) {
        return m_board->url();
    }
    return "";
}

const QString KitaSubjectView::boardName()
{
    if ( m_board ) {
        return m_board->name();
    }
    return "";
}

void KitaSubjectView::loadThread( QListViewItem* item )
{
    if ( ! item ) return ;

    QString datName = item->text( Row_DatName );
    KURL datURL = m_board->url();
    datURL.addPath( "/dat/" + datName );

    Kita::Board::setName( Kita::datToBoard( datURL.url() ), m_board->name() );
    Kita::Thread::setName( datURL.url(), item->text( Row_Subject ) );
    Kita::Thread* thread = Kita::Thread::getByURL( datURL.url() );

    KitaThreadInfo::setResNum( datURL.url(), item->text( Row_Read ).toInt() );
    emit signalShowThread( thread );
}

void KitaSubjectView::loadBoard( const Kita::Board* board )
{
    // reset member variables.
    // FIXME: FavoriteListView::update()˥ԡ
    {
        m_hitList.clear();
        m_nextHitIndex = 0;
        m_prevquery = "";
    }

    m_board = board;

    KitaThreadInfo* cache = KitaThreadInfo::getInstance();
    QPtrList<Kita::Thread> threadList = m_board->getThreadList();

    // clear list
    subjectList->clear();

    for ( unsigned i = 0; i < threadList.count(); i++ ) {
        Kita::Thread* thread = threadList.at( i );

        int readNum = cache->readNum( thread->datURL() );
        int resNum = thread->resNum();

        KListViewItem* item = new KListViewItem( subjectList );
        item->setText( Row_ID, QString( "%1" ).arg( i + 1, 4 ) );
        item->setText( Row_Subject, thread->name() );
        item->setText( Row_ResNum, QString( "%1" ).arg( resNum, 4 ) );
        item->setText( Row_Read, ( readNum > 0 ) ? QString( "%1" ).arg( readNum, 4 ) : QString( "" ) );
        item->setText( Row_Unread, ( readNum > 0 && resNum != readNum ) ? QString( "%1" ).arg( resNum - readNum, 4 ) : QString( "" ) );
        item->setText( Row_Board, thread->boardName() );
        item->setText( Row_DatName, KURL( thread->datURL() ).fileName() );
        item->setText( Row_DatURL, thread->datURL() );

        if ( readNum > 0 && resNum != readNum ) {
            // ̤ɤ
            item->setPixmap( Row_Mark, SmallIcon( "unread" ) );
        } else if ( readNum > 0 ) {
            // 
            item->setPixmap( Row_Mark, SmallIcon( "read" ) );
        }
    }

    if ( HideButton->isOn() ) {
        HideButton->toggle();
    }
    emit loadBoardCompleted( m_board->url() );

    subjectList->setFocus();
}

void KitaSubjectView::setFont( const QFont& font )
{
    subjectList->setFont( font );
}

void KitaSubjectView::updateThread( const Kita::Thread* updated_thread )
{
    for ( QListViewItem * item = subjectList->firstChild(); item; item = item->nextSibling() ) {
        if ( item->text( Row_DatURL ) == updated_thread->datURL() ) {
            int resNum = item->text( Row_ResNum ).toInt();
            int readNum = updated_thread->resNum();
            item->setText( Row_Read, QString( "%1" ).arg( readNum, 4 ) );
            item->setText( Row_Unread, readNum > 0 && resNum != readNum ? QString( "%1" ).arg( resNum - readNum, 4 ) : QString( "" ) );
        }
    }
}

void KitaSubjectView::slotContextMenuRequested( QListViewItem* item, const QPoint& point, int )
{
    if ( item == 0 ) {
        return ;
    }

    KPopupMenu popup( 0 );
    popup.insertItem( i18n( "Open with Web Browser" ), 0 );
    popup.insertItem( i18n( "Open with new tab" ), 1 );
    popup.insertItem( i18n( "Copy title and URL" ), 2 );

    QString datName = item->text( Row_DatName );
    KURL datURL = m_board->url();
    datURL.addPath( "/dat/" + datName );

    Kita::Board::setName( Kita::datToBoard( datURL.url() ), m_board->name() );
    Kita::Thread::setName( datURL.url(), item->text( Row_Subject ) );
    Kita::Thread* thread = Kita::Thread::getByURL( datURL.url() );
    KitaThreadInfo::setResNum( datURL.url(), item->text( Row_Read ).toInt() );

    QClipboard* clipboard = QApplication::clipboard();

    switch ( popup.exec( point ) ) {
    case 0:
        KRun::runURL( thread->url(), "text/html" );
        break;
    case 1:
        emit signalShowThreadWithNewTab( thread );
        break;
    case 2:
        clipboard->setText( thread->name() + "\n" + thread->url() );
        break;
    default:
        break;
    }
}
