/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITATHREADLISTVIEW_H
#define KITATHREADLISTVIEW_H

#include "threadlistviewbase.h"

#include <klistview.h>

enum ThreadListViewRows {
    Row_Mark,
    Row_ID,
    Row_Icon,
    Row_Subject,
    Row_ResNum,
    Row_Read,
    Row_Unread,
    Row_Board,
    Row_DatName,
    Row_DatURL
};

namespace Kita
{
    /**
    @author Hideki Ikemoto
    */
    class ThreadListView : public Kita::ThreadListViewBase
    {
        Q_OBJECT

    public:
        ThreadListView( QWidget* parent = 0, const char *name = 0 );
        ~ThreadListView();

    protected:
        QStringList m_prevquery;
        unsigned m_nextHitIndex;
        QValueList<KListViewItem *> m_hitList;

        void insertSearchCombo();
        QStringList parseSearchQuery( const QString& input );
        void searchNext( const QStringList& input );
        void searchAll( const QStringList& query );

    protected slots:
        void slotHideButton( bool on );

    private slots:
        void slotSearchButton();
    };

};

#endif
