/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "favoritelistview.h"

#include "libkita/favoritethreads.h"
#include "libkita/kita_misc.h"
#include "libkita/threadinfo.h"

#include <qmap.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qdatetime.h>
#include <qtoolbutton.h>

#include <klocale.h>
#include <kpopupmenu.h>
#include <krun.h>
#include <kdebug.h>
#include <klistview.h>

FavoriteListView::FavoriteListView( QWidget* parent, const char* name )
        : Kita::ThreadListView( parent, name )
{
    subjectList->addColumn( i18n( "Board" ) );

    ReloadButton->hide();

    connect( subjectList, SIGNAL( clicked( QListViewItem* ) ),
             SLOT( loadThread( QListViewItem* ) ) );
    connect( subjectList, SIGNAL( contextMenuRequested( QListViewItem*, const QPoint&, int ) ),
             SLOT( slotContextMenuRequested( QListViewItem*, const QPoint&, int ) ) );
}

FavoriteListView::~FavoriteListView()
{}

void FavoriteListView::update()
{
    // FIXME: KitaSubjectView::loadBoard()˥ԡ
    {
        m_hitList.clear();
        m_nextHitIndex = 0;
        m_prevquery = "";
    }

    const QValueList<QString> threadList = FavoriteThreads::getInstance() -> threadList();

    subjectList->clear();

    KitaThreadInfo* cache = KitaThreadInfo::getInstance();

    QValueList<QString>::const_iterator it;
    for ( it = threadList.begin(); it != threadList.end(); ++it ) {
        const Kita::Thread* thread = Kita::Thread::getByURL( *it );

        QDateTime since;
        since.setTime_t( KURL( thread->datURL() ).fileName().section( '.', 0, 0 ).toInt() );

        int readNum = cache->readNum( thread->datURL() );
        int resNum = KitaThreadInfo::resNum( thread->datURL() );

        KListViewItem* item = new KListViewItem( subjectList );
        item->setText( Col_Board, thread->boardName() );
        item->setText( Col_Subject, Kita::unescape( thread->name() ) );
        item->setText( Col_Read, QString( "%1" ).arg( readNum, 4 ) );
        if ( resNum > 0 ) {
            item->setText( Col_ResNum, QString( "%1" ).arg( resNum, 4 ) );
            if ( resNum != readNum ) {
                item->setText( Col_Unread, QString( "%1" ).arg( resNum - readNum, 4 ) );
            }
        }
        item->setText( Col_Since, since.toString( "yy/MM/dd hh:mm" ) );
        item->setText( Col_DatURL, thread->datURL() );
    }
}

void FavoriteListView::loadThread( QListViewItem* item )
{
    if ( ! item ) return ;

    const QValueList<QString> threadList = FavoriteThreads::getInstance() -> threadList();

    QValueList<QString>::const_iterator it;
    for ( it = threadList.begin(); it != threadList.end(); ++it ) {
        const Kita::Thread* thread = Kita::Thread::getByURL( *it );

        if ( thread->datURL() == item->text( Col_DatURL ) ) {
            emit showThreadRequested( thread, false );
        }
    }
}

void FavoriteListView::updateThread( const Kita::Thread* updated_thread )
{
    for ( QListViewItem * item = subjectList->firstChild(); item; item = item->nextSibling() ) {
        if ( item->text( Col_DatURL ) == updated_thread->datURL() ) {
            int resNum = updated_thread->resNum();
            int readNum = KitaThreadInfo::readNum( updated_thread->datURL() );
            item->setText( Col_ResNum, QString( "%1" ).arg( resNum, 4 ) );
            item->setText( Col_Read, QString( "%1" ).arg( readNum, 4 ) );
        }
    }
}

// TODO: KitaSubjectView饹Ʊ᥽åɤȤۤȤƱ
void FavoriteListView::slotContextMenuRequested( QListViewItem* item, const QPoint& point, int )
{
    if ( item == 0 ) {
        return ;
    }

    KPopupMenu popup( 0 );
    popup.insertItem( i18n( "Open with Web Browser" ), 0 );
    popup.insertItem( i18n( "Open with new tab" ), 1 );
    popup.insertItem( i18n( "Copy title and URL" ), 2 );

    Kita::Thread* thread = Kita::Thread::getByURL( item->text( Col_DatURL ) );

    QClipboard* clipboard = QApplication::clipboard();

    switch ( popup.exec( point ) ) {
    case 0:
        KRun::runURL( thread->url(), "text/html" );
        break;
    case 1:
        emit showThreadRequested( thread, true );
        break;
    case 2:
        clipboard->setText( thread->name() + "\n" + thread->url() );
        break;
    default:
        break;
    }
}
