/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "access.h"

#include "thread.h"
#include "qcp932codec.h"
#include "cache.h"
#include "threadinfo.h"

#include <config.h>

#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>

#include <kurl.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprotocolmanager.h>

#include <kio/slaveconfig.h>
#include <kio/netaccess.h>
#include <kio/jobclasses.h>
#include <kio/job.h>

#include <qregexp.h>
#include <qfile.h>
#include <qmessagebox.h>

using namespace Kita;

// copied from http.cc
// å夬ȤϤƤmallocΰ˥ԡ֤
// å夬ʤȤ0֤
QCString Access::getCacheData( const KURL& url )
{
    QString cachePath = Kita::Cache::getPath( url );

    FILE *fs = fopen( QFile::encodeName( cachePath ), "r" );
    if ( !fs ) {
        return 0;
    }

    struct stat buf;
    ::stat( QFile::encodeName( cachePath ), &buf );
    int pos = ftell( fs );
    int datasize = buf.st_size - pos;

    char* ret = static_cast<char *>( malloc( datasize + 1 ) );
    fread( ret, datasize, 1, fs );
    ret[ datasize ] = '\0';
    fclose( fs );
    return ret;
}

// å˽񤭹ߡ
// partial dataäƤΤǤ񤭴롣
void Access::writeCacheData( const KURL& url )
{
    if ( m_orgData.isNull() && responseCode() == 304 ) {
        m_threadData = QString::null;
        m_orgData = m_threadData;
        return ;
    } else if ( ! m_orgData.isNull() && responseCode() == 304 ) {
        m_threadData = m_orgData;
        return ;
    } else if ( ! m_orgData.isNull() && responseCode() == 206 ) {
        QCString orgData = QCString( m_orgData, m_orgData.length() );
        m_threadData = orgData + m_threadData;
    }
    m_orgData = m_threadData;

    QString cachePath = Kita::Cache::getPath( url );
    FILE *fs = fopen( QFile::encodeName( cachePath ), "w" );
    if ( !fs ) return ;

    fwrite( m_threadData, m_threadData.size(), 1, fs );
    fclose( fs );

    return ;
}

QString Access::getupdate()
{

    QString retstr;
    m_threadData = "";

    if ( KURL( m_thread->datURL() ).protocol() != "k2ch" ) {
        KIO::SlaveConfig::self() ->setConfigData( "http",
                KURL( m_thread->datURL() ).host(),
                "UserAgent",
                QString( "Monazilla/1.00 (Kita/%1)" ).arg( VERSION ) );
    }

    KIO::TransferJob* job = KIO::get( m_thread->datURL(), true, true );
    m_currentJob = job;

    connect( job, SIGNAL( data( KIO::Job*, const QByteArray& ) ),
             SLOT( slotReceiveThreadData( KIO::Job*, const QByteArray& ) ) );
    connect( job, SIGNAL( result( KIO::Job* ) ), SLOT( slotThreadResult( KIO::Job* ) ) );

    // use 'HTTP-Headers' metadata.
    job->addMetaData( "PropagateHttpHeader", "true" );
    if ( ! m_orgData.isNull() ) {
        job->addMetaData( "resume", QString::number( m_orgData.length() - 1 ) );
        job->addMetaData( "AllowCompressedPage", "false" );
    }

    enter_loop();

    if ( m_threadData.length() ) {
        QCp932Codec codec;
        retstr = codec.toUnicode( m_threadData );

        KURL url = m_thread->datURL();

        url.setProtocol( "k2ch" );
        
        // mkdir: $(KDRDIR)/share/cache/kita/pc.2ch.net/linux/xxxx.dat
        // ξ硢kita, pc.2ch.net, linux
        // TODO: 3ؤޤǤбƤʤΤʤȤ롣
        QString cachePath = Kita::Cache::getPath( url );
        KURL cacheDir = KURL( cachePath, "." );
        KURL cacheDir2 = KURL( cacheDir, ".." );
        KURL cacheDir3 = KURL( cacheDir2, ".." );
        if ( !KIO::NetAccess::exists( cacheDir3 ) ) {
            KIO::NetAccess::mkdir( cacheDir3 );
        }
        if ( !KIO::NetAccess::exists( cacheDir2 ) ) {
            KIO::NetAccess::mkdir( cacheDir2 );
        }
        if ( !KIO::NetAccess::exists( cacheDir ) ) {
            KIO::NetAccess::mkdir( cacheDir );
        }

        writeCacheData( url );
    } else retstr = "";

    return retstr;
}

// from netaccess.cpp
void qt_enter_modal( QWidget* widget );
void qt_leave_modal( QWidget* widget );

void Access::enter_loop()
{
    QWidget dummy( 0, 0, WType_Dialog | WShowModal );
    dummy.setFocusPolicy( QWidget::NoFocus );
    qt_enter_modal( &dummy );
    qApp->enter_loop();
    qt_leave_modal( &dummy );
}

void Access::slotReceiveThreadData( KIO::Job*, const QByteArray& data )
{
    QCString cstr( data.data(), data.size() + 1 );
    m_threadData.append( cstr );
}

void Access::slotThreadResult( KIO::Job* job )
{
    m_currentJob = 0;
    if ( job->error() ) {
        job->showErrorDialog();
    } else {
        m_header = job->queryMetaData( "HTTP-Headers" );
    }
    qApp->exit_loop();
}

void Access::killJob()
{
    if ( m_currentJob ) m_currentJob->kill();
}

int Access::serverTime()
{
    // parse HTTP headers
    QStringList headerList = QStringList::split( "\n", m_header );
    QRegExp regexp( "Date: (...), (..) (...) (....) (..:..:..) .*" );
    QString dateStr = headerList.grep( regexp ) [ 0 ];
    if ( regexp.search( dateStr ) == -1 ) {
        // invalid date format
        return QDateTime::currentDateTime().toTime_t();
    } else {
        // I hate this format ;p
        QString usLocalDateStr = regexp.cap( 1 ) + " " + regexp.cap( 3 ) + " " +
                                 regexp.cap( 2 ) + " " + regexp.cap( 5 ) + " " +
                                 regexp.cap( 4 );

        // 1970/01/01 00:00:00 GMT
        QDateTime zeroTime( QDate( 1970, 1, 1 ), QTime( 0, 0 ) );
        return zeroTime.secsTo( QDateTime::fromString( usLocalDateStr ) );
    }
}

int Access::responseCode()
{
    // parse HTTP headers
    QStringList headerList = QStringList::split( "\n", m_header );
    QRegExp regexp( "HTTP/1\\.[01] ([0-9]+) .*" );
    QString dateStr = headerList.grep( regexp ) [ 0 ];
    if ( regexp.search( dateStr ) == -1 ) {
        // invalid response
        return 0;
    } else {
        return regexp.cap( 1 ).toInt();
    }
}

QString Access::getcache()
{
    KURL url = m_thread->datURL();
    url.setProtocol( "k2ch" );

    m_orgData = getCacheData( url );

    QCp932Codec codec;
    return codec.toUnicode( m_orgData );

}

QString Access::get()
{
    QString ret;
    ret = getcache() + getupdate();

    return ret;
}

bool Access::deleteLog( const Thread* thread, QWidget* parent )
{
    if ( QMessageBox::warning( parent,
                               "Kita",
                               "Do you want to delete Log ?",
                               QMessageBox::Ok, QMessageBox::Cancel | QMessageBox::Default )
            == QMessageBox::Ok ) {

        KURL url = thread->datURL();
        QString str = Kita::Cache::getPath( url );
        KIO::NetAccess::del( str );

        url.setProtocol( "k2ch" );
        str = Kita::Cache::getPath( url );
        return KIO::NetAccess::del( str );
    }
    return FALSE;
}

#include "access.moc"
