/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITAACCESS_H
#define KITAACCESS_H

#include <qobject.h>
#include <qcstring.h>

class KURL;

namespace KIO
{
    class Job;
}

namespace Kita
{
    class Thread;

    /**
    @author Hideki Ikemoto
    */
    class Access : public QObject
    {
        Q_OBJECT

    public:
        Access( const Thread* thread ) : m_thread( thread ), m_currentJob( 0 ) {};
        ~Access() {};

        QString get();
        void killJob();
        int serverTime();
        QString getcache();
        QString getupdate();
        int responseCode();
        static bool deleteLog( const Thread* thread, QWidget* parent );

    private:
        QCString getCacheData( const KURL& url );
        void writeCacheData( const KURL& url );
        void enter_loop();

        const Thread* m_thread;
        KIO::Job* m_currentJob;
        QCString m_threadData;
        QString m_header;
        QCString m_orgData;

    private slots:
        void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
        void slotThreadResult( KIO::Job* job );

    signals:
        void redirection( const QString& );
    };

};

#endif
