/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "cache.h"

#include "kita_misc.h"

#include <kurl.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprotocolmanager.h>

using namespace Kita;

QString Cache::baseDir( const KURL& url )
{
    QString dir;
    if ( url.protocol() == "k2ch" ) {
        dir = KGlobal::dirs() ->saveLocation( "cache", "kita" );
    } else {
        dir = KProtocolManager::cacheDir();
    }
    if ( dir[ dir.length() - 1 ] != '/' )
        dir += "/";

    return dir;
}

QString Cache::getPath( const KURL& url )
{
    return baseDir( url ) + Kita::datToCache( url.url() );
}
