/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "commenttest.h"

using namespace Kita;

void CommentTest::setUp()
{
    m_normal = new Comment( "name<>mail<>03/11/03 00:39 ID:abcdefgh<>comment<>" );
    m_normal1 = new Comment( "name<>mail<>03/11/03 00:40 ID:12345678<>comment<>subject" );
    m_http = new Comment( "name<>mail<>03/11/03 00:41 ID:abcdefgh<>foo http://kita.sourceforge.jp/ bar<>" );
    m_ttp = new Comment( "name<>mail<>03/11/03 00:41 ID:abcdefgh<>foo ttp://kita.sourceforge.jp/ bar<>" );
    m_port = new Comment( "name<>mail<>03/11/03 00:42 ID:abcdefgh<>foo http://kita.sourceforge.jp:80/index.html bar<>" );
}

void CommentTest::tearDown()
{
    delete m_normal;
    delete m_normal1;
    delete m_http;
    delete m_ttp;
    delete m_port;
}

void CommentTest::testName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "name" ), m_normal->getName() );
    CPPUNIT_ASSERT_EQUAL( QString( "name" ), m_normal1->getName() );
    CPPUNIT_ASSERT_EQUAL( QString( "name" ), m_http->getName() );
    CPPUNIT_ASSERT_EQUAL( QString( "name" ), m_ttp->getName() );
    CPPUNIT_ASSERT_EQUAL( QString( "name" ), m_port->getName() );
}

void CommentTest::testAddress()
{
    CPPUNIT_ASSERT_EQUAL( QString( "mail" ), m_normal->getAddress() );
    CPPUNIT_ASSERT_EQUAL( QString( "mail" ), m_normal1->getAddress() );
    CPPUNIT_ASSERT_EQUAL( QString( "mail" ), m_http->getAddress() );
    CPPUNIT_ASSERT_EQUAL( QString( "mail" ), m_ttp->getAddress() );
    CPPUNIT_ASSERT_EQUAL( QString( "mail" ), m_port->getAddress() );
}

void CommentTest::testDateId()
{
    CPPUNIT_ASSERT_EQUAL( QString( "2003/11/03 00:39 ID:abcdefgh" ), m_normal->getDateId() );
    CPPUNIT_ASSERT_EQUAL( QString( "2003/11/03 00:40 ID:12345678" ), m_normal1->getDateId() );
    CPPUNIT_ASSERT_EQUAL( QString( "2003/11/03 00:41 ID:abcdefgh" ), m_http->getDateId() );
    CPPUNIT_ASSERT_EQUAL( QString( "2003/11/03 00:41 ID:abcdefgh" ), m_ttp->getDateId() );
    CPPUNIT_ASSERT_EQUAL( QString( "2003/11/03 00:42 ID:abcdefgh" ), m_port->getDateId() );
}

void CommentTest::testBody()
{
    CPPUNIT_ASSERT_EQUAL( QString( "comment" ), m_normal->getBody() );
    CPPUNIT_ASSERT_EQUAL( QString( "comment" ), m_normal1->getBody() );
    CPPUNIT_ASSERT_EQUAL( QString( "foo http://kita.sourceforge.jp/ bar" ), m_http->getBody() );
    CPPUNIT_ASSERT_EQUAL( QString( "foo ttp://kita.sourceforge.jp/ bar" ), m_ttp->getBody() );
    CPPUNIT_ASSERT_EQUAL( QString( "foo http://kita.sourceforge.jp:80/index.html bar" ), m_port->getBody() );
}

void CommentTest::testSubject()
{
    CPPUNIT_ASSERT_EQUAL( QString::null, m_normal->getSubject() );
    CPPUNIT_ASSERT_EQUAL( QString( "subject" ), m_normal1->getSubject() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_http->getSubject() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_ttp->getSubject() );
    CPPUNIT_ASSERT_EQUAL( QString::null, m_port->getSubject() );
}

void CommentTest::testIsValid()
{
    CPPUNIT_ASSERT( m_normal->isValid() );
    CPPUNIT_ASSERT( m_normal1->isValid() );
    CPPUNIT_ASSERT( m_http->isValid() );
    CPPUNIT_ASSERT( m_ttp->isValid() );
    CPPUNIT_ASSERT( m_port->isValid() );
}

void CommentTest::testToHtml()
{
    CPPUNIT_ASSERT_EQUAL( QString( "<dl><dt><span id=\"1\"/>1 "
                                   "<b><a href=\"mailto:mail\" title=\"mail\">name</a></b> "
                                   "2003/11/03 00:39 ID:abcdefgh</dt>"
                                   "<dd>comment<br/><br/></dd></dl>" ),
                          m_normal->toHtml( 1, false ) );
    CPPUNIT_ASSERT_EQUAL( QString( "<dl><dt><span id=\"1\"/>1 "
                                   "<b><a href=\"mailto:mail\" title=\"mail\">name</a></b> "
                                   "2003/11/03 00:40 ID:12345678</dt>"
                                   "<dd>comment<br/><br/></dd></dl>" ),
                          m_normal1->toHtml( 1, false ) );
    CPPUNIT_ASSERT_EQUAL( QString( "<dl><dt><span id=\"1\"/>1 "
                                   "<b><a href=\"mailto:mail\" title=\"mail\">name</a></b> "
                                   "2003/11/03 00:41 ID:abcdefgh</dt>"
                                   "<dd>foo <a href=\"http://kita.sourceforge.jp/\">http://kita.sourceforge.jp/</a> bar<br/><br/></dd></dl>" ),
                          m_http->toHtml( 1, false ) );
    CPPUNIT_ASSERT_EQUAL( QString( "<dl><dt><span id=\"1\"/>1 "
                                   "<b><a href=\"mailto:mail\" title=\"mail\">name</a></b> "
                                   "2003/11/03 00:41 ID:abcdefgh</dt>"
                                   "<dd>foo <a href=\"http://kita.sourceforge.jp/\">ttp://kita.sourceforge.jp/</a> bar<br/><br/></dd></dl>" ),
                          m_ttp->toHtml( 1, false ) );
    CPPUNIT_ASSERT_EQUAL( QString( "<dl><dt><span id=\"1\"/>1 "
                                   "<b><a href=\"mailto:mail\" title=\"mail\">name</a></b> "
                                   "2003/11/03 00:42 ID:abcdefgh</dt>"
                                   "<dd>foo <a href=\"http://kita.sourceforge.jp:80/index.html\">http://kita.sourceforge.jp:80/index.html</a> bar<br/><br/></dd></dl>" ),
                          m_port->toHtml( 1, false ) );
}
