/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef COMMENTTEST_H
#define COMMENTTEST_H

#include <cppunit/extensions/HelperMacros.h>
#include "../comment.h"

/**
@author Hideki Ikemoto
*/
class CommentTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( CommentTest );
    CPPUNIT_TEST( testName );
    CPPUNIT_TEST( testAddress );
    CPPUNIT_TEST( testDateId );
    CPPUNIT_TEST( testBody );
    CPPUNIT_TEST( testSubject );
    CPPUNIT_TEST( testIsValid );
    CPPUNIT_TEST( testToHtml );
    CPPUNIT_TEST_SUITE_END();

    Kita::Comment *m_normal, *m_normal1, *m_http, *m_ttp, *m_port;

public:
    void setUp();
    void tearDown();

    void testName();
    void testAddress();
    void testDateId();
    void testBody();
    void testSubject();
    void testIsValid();
    void testToHtml();
};

#endif
