/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "favoritethreadstest.h"

#include "../favoritethreads.h"
#include "../threadinfo.h"

void FavoriteThreadsTest::setUp()
{
    // FIXME: 2ĤΥåɤνѹȤޤʤ
    // FIXME: resnumϤʤ
    m_xml = "<favorites xmlns=\"http://kita.sourceforge.jp/ns/favorites\">\n"
            "<thread xmlns=\"http://kita.sourceforge.jp/ns/thread\">\n"
            "<daturl>http://pc.2ch.net/unix/dat/956134538.dat</daturl>\n"
            "<name>NeXT</name>\n"
            "<resnum>10</resnum>\n"
            "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
            "<url>http://pc.2ch.net/unix/</url>\n"
            "<name>Unix</name>\n"
            "</board>\n"
            "</thread>\n"
            "<thread xmlns=\"http://kita.sourceforge.jp/ns/thread\">\n"
            "<daturl>http://pc.2ch.net/linux/dat/1234567890.dat</daturl>\n"
            "<name>&lt;test> &amp;</name>\n"
            "<resnum>30</resnum>\n"
            "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
            "<url>http://pc.2ch.net/linux/</url>\n"
            "<name>Linux</name>\n"
            "</board>\n"
            "</thread>\n"
            "<thread xmlns=\"http://kita.sourceforge.jp/ns/thread\">\n"
            "<daturl>http://pc.2ch.net/linux/dat/1022744633.dat</daturl>\n"
            "<name>2ch browser thread</name>\n"
            "<resnum>20</resnum>\n"
            "<board xmlns=\"http://kita.sourceforge.jp/ns/board\">\n"
            "<url>http://pc.2ch.net/linux/</url>\n"
            "<name>Linux</name>\n"
            "</board>\n"
            "</thread>\n"
            "</favorites>\n";

    FavoriteThreads::readFromXML( m_xml );
}

void FavoriteThreadsTest::tearDown()
{}

void FavoriteThreadsTest::testToXML()
{
    CPPUNIT_ASSERT_EQUAL( m_xml, FavoriteThreads::getInstance() ->toXML() );
}

void FavoriteThreadsTest::testThreads()
{
    const QValueList<QString> threadList = FavoriteThreads::getInstance() ->threadList();
    CPPUNIT_ASSERT_EQUAL( ( uint ) 3, threadList.count() );

    Kita::Thread* thread1 = Kita::Thread::getByURL( threadList[ 0 ] );
    CPPUNIT_ASSERT_EQUAL( QString( "NeXT" ), thread1->name() );
    CPPUNIT_ASSERT_EQUAL( 10, thread1->resNum() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/unix/" ), thread1->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), thread1->boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), thread1->boardID() );

    Kita::Thread* thread2 = Kita::Thread::getByURL( threadList[ 1 ] );
    CPPUNIT_ASSERT_EQUAL( QString( "&lt;test&gt; &amp;" ), thread2->name() );
    CPPUNIT_ASSERT_EQUAL( 30, thread2->resNum() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), thread2->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), thread2->boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), thread2->boardID() );
    
    Kita::Thread* thread3 = Kita::Thread::getByURL( threadList[ 2 ] );
    CPPUNIT_ASSERT_EQUAL( QString( "2ch browser thread" ), thread3->name() );
    CPPUNIT_ASSERT_EQUAL( 20, thread3->resNum() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), thread3->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), thread3->boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), thread3->boardID() );
}

void FavoriteThreadsTest::testReplace()
{
    QString fromURL = "http://pc.2ch.net/unix";
    QString toURL = "http://pc3.2ch.net/unix";
    FavoriteThreads::replace( fromURL, toURL );
    Kita::Thread::replace( fromURL, toURL );
    KitaThreadInfo::replace( fromURL, toURL );

    const QValueList<QString> threadList = FavoriteThreads::getInstance() ->threadList();
    CPPUNIT_ASSERT_EQUAL( ( uint ) 3, threadList.count() );

    Kita::Thread* thread1 = Kita::Thread::getByURL( threadList[ 0 ] );
    CPPUNIT_ASSERT_EQUAL( QString( "NeXT" ), thread1->name() ); // error.
    CPPUNIT_ASSERT_EQUAL( 10, thread1->resNum() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc3.2ch.net/unix/" ), thread1->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), thread1->boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), thread1->boardID() );

    Kita::Thread* thread2 = Kita::Thread::getByURL( threadList[ 1 ] );
    CPPUNIT_ASSERT_EQUAL( QString( "&lt;test&gt; &amp;" ), thread2->name() );
    CPPUNIT_ASSERT_EQUAL( 30, thread2->resNum() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), thread2->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), thread2->boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), thread2->boardID() );
    
    Kita::Thread* thread3 = Kita::Thread::getByURL( threadList[ 2 ] );
    CPPUNIT_ASSERT_EQUAL( QString( "2ch browser thread" ), thread3->name() );
    CPPUNIT_ASSERT_EQUAL( 20, thread3->resNum() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), thread3->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), thread3->boardName() );
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), thread3->boardID() );
}
