/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "threadinfo.h"

#include <kurl.h>

#include <qmap.h>
#include <qdatastream.h>

KitaThreadInfo* KitaThreadInfo::instance = 0;

KitaThreadInfo::KitaThreadInfo() : m_readDict()
{
}

KitaThreadInfo::~KitaThreadInfo()
{
}

KitaThreadInfo* KitaThreadInfo::getInstance()
{
  if( instance == 0 ) {
    instance = new KitaThreadInfo();
  }
  return instance;
}

int KitaThreadInfo::readNum( const QString& url )
{
  KitaThreadInfo* instance = KitaThreadInfo::getInstance();
  if( instance->m_readDict.contains( url ) ) {
    return instance->m_readDict[ url ];
  } else {
    return 0;
  }
}

void KitaThreadInfo::setReadNum( const QString& url, int num )
{
  KitaThreadInfo* instance = KitaThreadInfo::getInstance();
  instance->m_readDict.insert( url, num );
}

int KitaThreadInfo::resNum( const QString& url )
{
  KitaThreadInfo* instance = KitaThreadInfo::getInstance();
  if( instance->m_resNumDict.contains( url ) ) {
    return instance->m_resNumDict[ url ];
  } else {
    return 0;
  }
}

void KitaThreadInfo::setResNum( const QString& url, int num )
{
  KitaThreadInfo* instance = KitaThreadInfo::getInstance();
  instance->m_resNumDict.insert( url, num );
}

void KitaThreadInfo::replace( const QString fromURL, const QString toURL )
{
    QMap<QString, int>::Iterator it;
    KitaThreadInfo* instance = KitaThreadInfo::getInstance();
    
    for( it = instance->m_readDict.begin(); it != instance->m_readDict.end(); ++it ) {
        QString url = it.key();
        int num = it.data();
        if ( url.find( fromURL ) == 0 ) {
            url = url.replace( 0, fromURL.length(), toURL );
            instance->m_readDict.erase( it );
            instance->m_readDict.insert( url, num );
            it = instance->m_readDict.begin(); // TODO äᤤˡ?
        }
    }

    QMap<QString, int>::Iterator it2;
    for( it2 = instance->m_resNumDict.begin(); it2 != instance->m_resNumDict.end(); ++it2 ) {
        QString url = it2.key();
        int num = it2.data();
        if ( url.find( fromURL ) == 0 ) {
            url = url.replace( 0, fromURL.length(), toURL );
            instance->m_resNumDict.erase( it2 );
            instance->m_resNumDict.insert( url, num );
            it2 = instance->m_resNumDict.begin();
        }
    }
}

QDataStream& operator<<( QDataStream& s, KitaThreadInfo& c )
{
  s << c.m_readDict;
  return s;
}

QDataStream& operator>>( QDataStream& s, KitaThreadInfo& c )
{
  s >> c.m_readDict;
  return s;
}
