/**************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto , (c)2004 by 421                 *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
**************************************************************************/

#ifndef KITADOMTREE_H
#define KITADOMTREE_H

#include <kurl.h>
#include <khtml_part.h>
#include <dom/html_element.h>
#include <dom/dom_text.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qstringlist.h>
#include <qobject.h>
#include <kglobal.h>
#include <kprotocolmanager.h>
#include <kstandarddirs.h>
#include <qtextcodec.h>
#include <klocale.h>
#include <qsemaphore.h>
#include <qthread.h>

#include "kitahtmlpart.h"
#include "kitahtmlview.h"
#include "libkita/thread.h"
#include "libkita/cache.h"

namespace Kita
{
    class Thread;
}
class KitaRenderThread;

#define KITADOM_RESDIGIT 4
#define KITADOM_MAXRES 1200

class KitaDomTree
{
    /* basic informations */
    KitaHTMLPart* m_threadPart;
    Kita::Thread* m_thread;
    KURL m_url;
    QString m_subject;
    bool m_showaddr;
    bool m_showAA;
    QString m_linedat[ KITADOM_MAXRES + 1 ]; /* string data */
    bool m_linedatset[ KITADOM_MAXRES + 1 ]; /* already set */
    int m_templateNum;
    int m_topNum;
    int m_bottomNum;
    int m_maxNum; /* = KitaThreadInfo::readNum(m_thread->datURL()) */
    int m_kokoyonNum; /* where kokomade yonda is set */
    bool m_broken;

    /*
    1 <-- show --> m_templateNum <-- not shown -->
      m_topNum <-- shown ---> m_bottomNum <-- not shown --> m_maxNum 
    */

    /* for DOM  */
    DOM::HTMLDocument m_hdoc; /* root node of document*/
    DOM::Element m_res[ KITADOM_MAXRES + 1 ];
    bool m_resparsed[ KITADOM_MAXRES + 1 ]; /* already parsed */
    bool m_resshown[ KITADOM_MAXRES + 1 ]; /* already shown */
    DOM::Element m_header;
    DOM::Element m_footer;
    DOM::Element m_kokoyon;
    DOM::Element m_tugi100;
    DOM::Element m_mae100;
    bool m_appendtugi100;
    bool m_appendmae100;
    QString m_linestr;

    QSemaphore* m_semap;
    KitaRenderThread* m_krt;

    /* for image node */
    int m_imgnum;
    int m_imgsize;

    /* Japanese string */
    QString m_clnamestr;
    QString m_colonstr;

    /* for Abone */
    bool m_checkAbone[ KITADOM_MAXRES + 1 ];
    bool m_abone[ KITADOM_MAXRES + 1 ];
    QStringList m_namelist;
    QStringList m_idlist;
    QStringList m_wordlist;
    bool m_resAbone;

    /* for searching */
    bool m_initFindText;
    DOM::Node m_findNode;
    int m_findPos;
    int m_find_y;

    /*-------------------------------------------------------------*/

public:

    KitaDomTree( KitaHTMLPart* threadPart );
    ~KitaDomTree();

    /* parsing & rendering */

    /* (1) parseResInit
    -> (2) setDat
    -> (3) parseRes
    -> (4) appendRes  */

    void parseResInit( Kita::Thread* thread,
                       const QString& style,
                       int templateNum );
    void setDat( const QString& line, int num );
    void parseRes( int num, int resnum );
    bool appendRes( int num, bool binsert );
    bool removeRes( int num );

    void parseAllRes();
    void TerminateParseThread();
    void StopParseThread();

    /* utilities */

    bool isResDataSet( int num ) { return m_linedat[ QMIN( num, KITADOM_MAXRES - 1 ) ];}
    bool isResShown( int num ) { return m_resshown[ QMIN( num, KITADOM_MAXRES - 1 ) ]; }
    const QString& getSubject() { return m_subject;}
    int getTopResNumber() { return m_topNum;}
    int getBottomResNumber() { return m_bottomNum;}
    int getMaxResNumber() { return m_maxNum;}
    int getTemplateNumber() { return m_templateNum;}
    void setTemplateNumber( int tmp ) {m_templateNum = tmp;}
    bool isBroken() { return m_broken;}

    QString getDat( int num );
    QString getHtml( int startnum, int endnum );
    QString getHtmlByID( QString strid, int &num );
    int getNumByID( QString strid );
    QString getResStr( int num, QString qtstr );

    bool CheckID( QString strid, int num );
    bool CheckWord( QStringList stlist, int num, bool checkOR );
    bool CheckRes( int target, int num );

    /* header Node, footer Node, kokomadeyonda Node, etc... */

    void appendTemplate();
    void appendFooter( int resnum );

    void appendKokoyon();
    void setKokoyonNum( int kokoyonNum ) {m_kokoyonNum = kokoyonNum;}
    int getKokoyonNum() { return m_kokoyonNum;}

    void appendTugi100();
    void removeTugi100();
    bool isTugi100Shown() { return m_appendtugi100;}

    void appendMae100();
    void removeMae100();
    bool isMae100Shown() { return m_appendmae100;}

    void createCommentNode( QString comment, QString idstr, int beforeBR, int afterBR, bool binsert );
    void createBeltNode( QString idstr );

    /* for searching */
    void findTextInit();
    bool findText( const QString &str, bool reverse );

    /*-------------------------------------------------------------*/

private:

    /* for init */
    void createHTMLDocument( const QString& style );
    void resetAllVar();

    /* for parsing & rendering */
    DOM::Element createTitleNode(
        int num, bool showMailAddress,
        QString &str_name,
        QString &str_address,
        QString &str_id,
        QString &str_dateId,
        QDateTime &dt_dateTime );

    DOM::Element createBodyTextNode( QString &str_body );

    void parseHTMLdat( DOM::Element &bodynode, QString &str );
    void appendColoredTextNode( DOM::Element &root, QString str, QString style );
    bool createResAnchor(
        DOM::Element &bodynode, QString &str, const QChar *chpt,
        unsigned int &i, unsigned int &index );

    /* copied from comment.cpp */
    void parseDateId( const QString& str ,
                      QString &str_id,
                      QString &str_dateId, QDateTime &dt_dateTime );

    /* utils */
    int checkIsNumValid( int num );
    QString extractText( DOM::Node rootnode, const char* termstr, const QString br_str );
    QString getHtmlCore( int num );
    bool checkAbone( int num );

    /* for footer,header node, etc.. */
    DOM::Element createFooter( QString kitatype );
    void createKokoyon();
    void createTugi100();
    void createMae100();
};



/*-----------------------------------------------*/
/* class to parse dat file in background */

class KitaRenderThread : public QThread
{

    KitaDomTree* m_domtree;
    int m_maxNum;
    bool m_run;

public:

    KitaRenderThread( KitaDomTree* domtree ) : m_domtree( domtree ) {};
    ~KitaRenderThread() {};

    void setMaxNum( int maxNum ) { m_maxNum = maxNum; }
    void stopRender() { m_run = FALSE; }
    virtual void run()
    {
        m_run = TRUE;
        int tmpnum = m_domtree->getTemplateNumber();
        for ( int i = tmpnum; i >= 1; i-- ) {
            m_domtree->parseRes( i, i );
        }
        for ( int i = m_maxNum ; i >= tmpnum && m_run ; i-- ) {
            m_domtree->parseRes( i, i );
        }
    };
};


#endif
