/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAHTMLPART_H
#define KITAHTMLPART_H

#include <kurl.h>
#include <khtml_part.h>

#include <qstringlist.h>

#include <qvaluestack.h> // for gcc-2.9x
template <class T> class QValueStack;

namespace Kita
{
    class Thread;
}

class KPopupMenu;

#include <qstringlist.h>
class KitaDomTree;
class KitaThreadView;

/**
@author Hideki Ikemoto
*/
class KitaHTMLPart : public KHTMLPart
{
    Q_OBJECT

    KURL m_url;
    QWidget* m_parent;
    int m_hitCount;
    QStringList m_prevQuery;
    QString m_contents;
    int m_nextHit;
    QValueStack<QPoint> m_pointStack;
    KPopupMenu* m_popupMenu;
    bool m_pushctrl;
    bool m_pushmidbt;
    KitaDomTree* m_domtree;
    KitaThreadView* m_threadView;
    Kita::Thread* m_thread;
    QStringList m_anchorStack;

public:
    int nextHit();
    void resetHit() { m_nextHit = -1; }
    const QStringList prevQuery() const { return m_prevQuery; }
    void pushCurrentPosition();
    void reset();
    bool gotoAnchor( const QString& name );

public:
    KitaHTMLPart( QWidget* parent, const char* name = 0 );
    ~KitaHTMLPart();
    void highLighten( bool yes, const QStringList& query );
    void highLightenNodes( DOM::NodeList nodes, const QStringList& query );
    static QStringList lt_gt_spliter( const QString& input );
    void gotoURL( const Kita::Thread* thread, int prevResNum );
    void displayContents( const QString& input, const KURL& urlOfInput = 0 );
    void setupEx( KitaThreadView* threadView, KitaDomTree* domtree,
                  Kita::Thread* thread );
    void gotoKokoyon();

protected:
    virtual void khtmlMousePressEvent( khtml::MousePressEvent* e );
    virtual void khtmlMouseReleaseEvent( khtml::MouseReleaseEvent *e );
    virtual void khtmlMouseMoveEvent( khtml::MouseMoveEvent* e );

public slots:
    bool gobackAnchor();

private:
    const QString contents() const { return m_contents; }
    void clearPosition() { m_pointStack.clear(); }

private slots:
    void slotPopupMenu( const QString& url, const QPoint& point );

signals:
    void setLocationBarURL( const QString &url );
};

#endif
