/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITATHREADVIEW_H_
#define _KITATHREADVIEW_H_

#include "kitathreadviewbase.h"

#include <kparts/browserextension.h>
#include <dom/html_base.h>

#include <qtextbrowser.h>

#include "kita2ch.h"
#include "libkita/thread.h"
#include "kitadomtree.h"

class KURL;
class KitaHTMLPart;
class KitaWriteDialog;

#include <qvaluestack.h> // for gcc-2.9x
template <class T> class QValueStack;

namespace Kita
{
    class Access;
    class PopupTextBrowser;
    class ResPopup;
};

/* mode , m_viewmode uses them. */
enum{
    VIEWMODE_PARENT,
    VIEWMODE_KITANAVI,
    VIEWMODE_PREVIEW
};

namespace KIO
{
    class Job;
};

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/

class KitaThreadView : public KitaThreadViewBase
{
    Q_OBJECT

public:
    KitaThreadView( QWidget* parent, const char* name = 0 );
    ~KitaThreadView();
    const QString threadName() const;
    const KURL threadURL() const;
    void searchNext( const QStringList& input );
    void killJob();
    void focusSearchCombo();

    void setupEx( const Kita::Thread* thread,
                  Kita::Access* access,
                  KitaThreadView* viewparent,
                  KitaDomTree* domtreeparent,
                  int mode );
    void showStatusBar( QString info );
    void gotoAnchor( QString anc );
    Kita::Thread* get2chThread() { return m_thread; }
    int getViewMode() { return m_viewmode; }

    /* !! static !! */
    static KURL filterReadCGICore( const KURL&, Kita::Thread* thread );
    static void getRefNumber( const KURL& url, Kita::Thread* thread,
                              int& renNum, int& refNum2 );

    /* for preview and KitaNavi */    
    void domAppendData(QString& str,int bufnum,int num );
    void domDeleteRes(int bufnum);
    void domAppendBelt(QString idstr);
    void domAppendHTML(QString& url,QString& html);
    void domApplyChange(QString lbstr,QString hstr,QString fstr,QString anchor,QString cmbstr);
    
public slots:
    void showThread( const Kita::Thread* thread );
    void setFont( const QFont& font );
    void slotReloadButton();
    void slotOpenURLRequest( const KURL&, const KParts::URLArgs& );

protected slots:
    void slotDOMNodeActivated( const DOM::Node& node );
    void slotPopupMenu( KXMLGUIClient*, const QPoint&, const KURL&, const QString&, mode_t );

private:       // Private attributes
    Kita::Access* m_access;
    Kita::Thread* m_thread;
    KitaHTMLPart* m_threadPart;
    Kita::PostInfo m_postInfo;
    Kita::ResPopup* m_popup;

    KitaDomTree* m_domtree;
    bool m_revsearch;
    int m_viewmode;
    int m_rescode;

    /* for config */
    int m_preShowNum;
    int m_afterShowNum;
    QString m_mailaddr;
    int m_maxpopup;
    QString m_style;
    bool m_online;

    /* for KitaNavi */
    KitaDomTree* m_domtreeparent;
    KitaThreadView* m_viewparent;

    void update_readCache();
    void update_rendering( bool breload );
    void update_finish();
    void update_copydata( const QString& linedata, int basenum );

    void appendRes( int startnum, int endnum );
    void showPopup( QString innerHTML, QString imgfile );
    void slotWriteButtonClickedCore( QString resstr );

    void insertSearchCombo();
    KURL filterReadCGI( const KURL& );
    void setSubjectLabel( const QString& boardName, const QString& threadName );
    KitaWriteDialog* openDialog( const Kita::PostInfo& info );
    const QString footer() const;
    QStringList parseSearchQuery( const QString& input ) const;
    void updateButton();

private slots:
    void slotSearchButton();
    void slotHighLightenButton( bool yes );
    void slotOnURL( const QString& url );
    void slotPostStarted( KIO::Job*, const Kita::PostInfo& );
    void slotBookmarkButtonClicked( bool on );
    void slotWriteButtonClicked();
    void slotShowErrorDialog( const QString& input, const KURL& urlOfInput = 0 );
    void hidePopup();

signals:
    void showThreadCompleted( const KURL& threadUrl );
    void datURLRedirected( const KURL& newDatURL );
    void signalChangeStatusbar( const QString& );
    void postResponse( const QString& response, const KURL& bbscgi = KURL() );
    //re-impl signals of KParts::Browserextension of KHTMLPart
    void openURLRequest( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
    void createNewWindow( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
    void setLocationBarURL( const QString& url );
    void enableAction( const char* name, bool enabled );
    void popupMenu( KXMLGUIClient*, const QPoint&, const KURL&, const QString&, mode_t );
    void thread( const Kita::Thread* );
    void writeSucceeded();
    void bookmarked( const Kita::Thread*, bool on );
};

namespace Kita
{
    class PopupTextBrowser : public QTextBrowser
    {
    public:
        PopupTextBrowser( QFrame* frame );
        ~PopupTextBrowser();
    };

    class ResPopup : public QFrame
    {
        KHTMLPart* m_part;
        Kita::PopupTextBrowser* m_browser;
    public:
        ResPopup( KHTMLView* view );
        ~ResPopup();
        void setText( QString& str );
        void adjustSize();
    };
}

#endif
